/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.scheduler;

import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.util.ObjectValuePair;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobState
implements Cloneable,
Serializable {
    public static final int VERSION = 1;
    private static final int _EXCEPTIONS_MAX_SIZE = 10;
    private static final long serialVersionUID = 5747422831990881126L;
    private Queue<ObjectValuePair<Exception, Date>> _exceptions;
    private int _exceptionsMaxSize;
    private Map<String, Date> _triggerDates;
    private TriggerState _triggerState;

    public JobState(TriggerState triggerState) {
        this(triggerState, 10);
    }

    public JobState(TriggerState triggerState, int exceptionsMaxSize) {
        if (exceptionsMaxSize <= 0) {
            exceptionsMaxSize = 10;
        }
        this._triggerState = triggerState;
        this._exceptionsMaxSize = exceptionsMaxSize;
    }

    public JobState(TriggerState triggerState, int exceptionsMaxSize, Map<String, Date> triggerDates) {
        this(triggerState, exceptionsMaxSize);
        this._triggerDates = new HashMap<String, Date>(triggerDates);
    }

    public void addException(Exception exception, Date date) {
        if (this._exceptions == null) {
            this._exceptions = new LinkedList<ObjectValuePair<Exception, Date>>();
        }
        this._exceptions.add(new ObjectValuePair<Exception, Date>(exception, date));
        while (this._exceptions.size() > this._exceptionsMaxSize) {
            this._exceptions.poll();
        }
    }

    public void clearExceptions() {
        if (this._exceptions != null && !this._exceptions.isEmpty()) {
            this._exceptions.clear();
        }
    }

    public Object clone() {
        JobState jobState = new JobState(this._triggerState, this._exceptionsMaxSize);
        if (this._exceptions != null) {
            LinkedList<ObjectValuePair<Exception, Date>> exceptions = new LinkedList<ObjectValuePair<Exception, Date>>();
            exceptions.addAll(this._exceptions);
            jobState._exceptions = exceptions;
        }
        if (this._triggerDates != null) {
            HashMap<String, Date> triggerTimeInfomation = new HashMap<String, Date>();
            triggerTimeInfomation.putAll(this._triggerDates);
            jobState._triggerDates = triggerTimeInfomation;
        }
        return jobState;
    }

    public ObjectValuePair<Exception, Date>[] getExceptions() {
        if (this._exceptions == null) {
            return null;
        }
        return this._exceptions.toArray(new ObjectValuePair[this._exceptions.size()]);
    }

    public int getExceptionsMaxSize() {
        return this._exceptionsMaxSize;
    }

    public Date getTriggerDate(String key) {
        if (this._triggerDates == null) {
            return null;
        }
        return this._triggerDates.get(key);
    }

    public Map<String, Date> getTriggerDates() {
        if (this._triggerDates == null) {
            return Collections.EMPTY_MAP;
        }
        return this._triggerDates;
    }

    public TriggerState getTriggerState() {
        return this._triggerState;
    }

    public void setTriggerDate(String key, Date date) {
        if (this._triggerDates == null) {
            this._triggerDates = new HashMap<String, Date>();
        }
        this._triggerDates.put(key, date);
    }

    public void setTriggerState(TriggerState triggerState) {
        this._triggerState = triggerState;
    }
}

