/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.cluster.messaging.ClusterBridgeMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.InvokerMessageListener;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.ParallelDestination;
import com.liferay.portal.kernel.messaging.SynchronousDestination;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchEngineProxyWrapper;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.messaging.BaseSearchEngineMessageListener;
import com.liferay.portal.kernel.search.messaging.SearchReaderMessageListener;
import com.liferay.portal.kernel.search.messaging.SearchWriterMessageListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSearchEngineConfigurator {
    private List<SearchEngineRegistration> _searchEngineRegistrations = new ArrayList<SearchEngineRegistration>();
    private List<SearchEngine> _searchEngines;

    public void afterPropertiesSet() {
        for (SearchEngine searchEngine : this._searchEngines) {
            this.initSearchEngine(searchEngine);
        }
        this._searchEngines.clear();
    }

    public void destroy() {
        for (SearchEngineRegistration searchEngineRegistration : this._searchEngineRegistrations) {
            this.destroySearchEngine(searchEngineRegistration);
        }
        this._searchEngineRegistrations.clear();
    }

    public void setSearchEngines(List<SearchEngine> searchEngines) {
        this._searchEngines = searchEngines;
    }

    protected void createSearchEngineListeners(SearchEngine searchEngine, Destination searchReaderDestination, Destination searchWriterDestination) {
        this.registerSearchEngineMessageListener(searchEngine, searchReaderDestination, new SearchReaderMessageListener(), searchEngine.getIndexSearcher());
        this.registerSearchEngineMessageListener(searchEngine, searchWriterDestination, new SearchWriterMessageListener(), searchEngine.getIndexWriter());
        if (searchEngine.isClusteredWrite()) {
            ClusterBridgeMessageListener clusterBridgeMessageListener = new ClusterBridgeMessageListener();
            clusterBridgeMessageListener.setPriority(searchEngine.getClusteredWritePriority());
            searchWriterDestination.register(clusterBridgeMessageListener);
        }
    }

    protected void destroySearchEngine(SearchEngineRegistration searchEngineRegistration) {
        MessageBus messageBus = this.getMessageBus();
        Destination searchReaderDestination = messageBus.removeDestination(searchEngineRegistration.getSearchReaderDestinationName());
        searchReaderDestination.close(true);
        Destination searchWriterDestination = messageBus.removeDestination(searchEngineRegistration.getSearchWriterDestinationName());
        searchWriterDestination.close(true);
        SearchEngine searchEngine = searchEngineRegistration.getSearchEngine();
        SearchEngineUtil.removeSearchEngine(searchEngine.getName());
        if (!searchEngineRegistration.isOverride()) {
            return;
        }
        SearchEngineProxyWrapper originalSearchEngineProxy = searchEngineRegistration.getOriginalSearchEngineProxyWrapper();
        SearchEngine originalSearchEngine = originalSearchEngineProxy.getSearchEngine();
        searchReaderDestination = this.getSearchReaderDestination(messageBus, originalSearchEngine);
        this.registerInvokerMessageListener(searchReaderDestination, searchEngineRegistration.getOriginalSearchReaderMessageListeners());
        searchWriterDestination = this.getSearchWriterDestination(messageBus, originalSearchEngine);
        this.registerInvokerMessageListener(searchWriterDestination, searchEngineRegistration.getOriginalSearchWriterMessageListeners());
        SearchEngineUtil.addSearchEngine(originalSearchEngineProxy);
    }

    protected abstract IndexSearcher getIndexSearcher();

    protected abstract IndexWriter getIndexWriter();

    protected abstract MessageBus getMessageBus();

    protected abstract ClassLoader getOperatingClassloader();

    protected Destination getSearchReaderDestination(MessageBus messageBus, SearchEngine searchEngine) {
        String searchReaderDestinationName = SearchEngineUtil.getSearchReaderDestinationName(searchEngine.getName());
        Destination searchReaderDestination = messageBus.getDestination(searchReaderDestinationName);
        if (searchReaderDestination == null) {
            SynchronousDestination synchronousDestination = new SynchronousDestination();
            synchronousDestination.setName(searchReaderDestinationName);
            synchronousDestination.open();
            searchReaderDestination = synchronousDestination;
            messageBus.addDestination(searchReaderDestination);
        }
        return searchReaderDestination;
    }

    protected Destination getSearchWriterDestination(MessageBus messageBus, SearchEngine searchEngine) {
        String searchWriterDestinationName = SearchEngineUtil.getSearchWriterDestinationName(searchEngine.getName());
        Destination searchWriterDestination = messageBus.getDestination(searchWriterDestinationName);
        if (searchWriterDestination == null) {
            ParallelDestination parallelDestination = new ParallelDestination();
            parallelDestination.setName(searchWriterDestinationName);
            parallelDestination.open();
            searchWriterDestination = parallelDestination;
            messageBus.addDestination(searchWriterDestination);
        }
        return searchWriterDestination;
    }

    protected void initSearchEngine(SearchEngine searchEngine) {
        SearchEngineRegistration searchEngineRegistration = new SearchEngineRegistration(searchEngine);
        this._searchEngineRegistrations.add(searchEngineRegistration);
        MessageBus messageBus = this.getMessageBus();
        Destination searchReaderDestination = this.getSearchReaderDestination(messageBus, searchEngine);
        searchEngineRegistration.setSearchReaderDestinationName(searchReaderDestination.getName());
        Destination searchWriterDestination = this.getSearchWriterDestination(messageBus, searchEngine);
        searchEngineRegistration.setSearchWriterDestinationName(searchWriterDestination.getName());
        SearchEngine originalSearchEngine = SearchEngineUtil.getSearchEngine(searchEngine.getName());
        if (originalSearchEngine != null) {
            searchEngineRegistration.setOverride(true);
            searchEngineRegistration.setOriginalSearchEngineProxyWrapper((SearchEngineProxyWrapper)originalSearchEngine);
            this.savePreviousSearchEngineListeners(searchReaderDestination, searchWriterDestination, searchEngineRegistration);
            messageBus.removeDestination(searchReaderDestination.getName());
            searchReaderDestination = this.getSearchReaderDestination(messageBus, originalSearchEngine);
            messageBus.removeDestination(searchWriterDestination.getName());
            searchWriterDestination = this.getSearchWriterDestination(messageBus, originalSearchEngine);
        }
        this.createSearchEngineListeners(searchEngine, searchReaderDestination, searchWriterDestination);
        SearchEngineProxyWrapper searchEngineProxyWrapper = new SearchEngineProxyWrapper(searchEngine, this.getIndexSearcher(), this.getIndexWriter());
        SearchEngineUtil.addSearchEngine(searchEngineProxyWrapper);
    }

    protected void registerInvokerMessageListener(Destination destination, List<InvokerMessageListener> invokerMessageListeners) {
        for (InvokerMessageListener invokerMessageListener : invokerMessageListeners) {
            destination.register(invokerMessageListener.getMessageListener(), invokerMessageListener.getClassLoader());
        }
    }

    protected void registerSearchEngineMessageListener(SearchEngine searchEngine, Destination destination, BaseSearchEngineMessageListener baseSearchEngineMessageListener, Object manager) {
        baseSearchEngineMessageListener.setManager(manager);
        baseSearchEngineMessageListener.setMessageBus(this.getMessageBus());
        baseSearchEngineMessageListener.setSearchEngine(searchEngine);
        destination.register(baseSearchEngineMessageListener, this.getOperatingClassloader());
    }

    protected void savePreviousSearchEngineListeners(Destination searchReaderDestination, Destination searchWriterDestination, SearchEngineRegistration searchEngineRegistration) {
        Set<MessageListener> searchReaderMessageListeners = searchReaderDestination.getMessageListeners();
        for (MessageListener searchReaderMessageListener : searchReaderMessageListeners) {
            InvokerMessageListener invokerMessageListener = (InvokerMessageListener)searchReaderMessageListener;
            searchEngineRegistration.addOriginalSearchReaderMessageListener(invokerMessageListener);
        }
        Set<MessageListener> searchWriterMessageListeners = searchWriterDestination.getMessageListeners();
        for (MessageListener searchWriterMessageListener : searchWriterMessageListeners) {
            InvokerMessageListener invokerMessageListener = (InvokerMessageListener)searchWriterMessageListener;
            searchEngineRegistration.addOriginalSearchWriterMessageListener(invokerMessageListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SearchEngineRegistration {
        private SearchEngineProxyWrapper _originalSearchEngineProxyWrapper;
        private List<InvokerMessageListener> _originalSearchReaderMessageListeners = new ArrayList<InvokerMessageListener>();
        private List<InvokerMessageListener> _originalSearchWriterMessageListeners = new ArrayList<InvokerMessageListener>();
        private boolean _override;
        private SearchEngine _searchEngine;
        private String _searchReaderDestinationName;
        private String _searchWriterDestinationName;

        private SearchEngineRegistration(SearchEngine searchEngine) {
            this._searchEngine = searchEngine;
        }

        public void addOriginalSearchReaderMessageListener(InvokerMessageListener messageListener) {
            this._originalSearchReaderMessageListeners.add(messageListener);
        }

        public void addOriginalSearchWriterMessageListener(InvokerMessageListener messageListener) {
            this._originalSearchWriterMessageListeners.add(messageListener);
        }

        public SearchEngineProxyWrapper getOriginalSearchEngineProxyWrapper() {
            return this._originalSearchEngineProxyWrapper;
        }

        public List<InvokerMessageListener> getOriginalSearchReaderMessageListeners() {
            return this._originalSearchReaderMessageListeners;
        }

        public List<InvokerMessageListener> getOriginalSearchWriterMessageListeners() {
            return this._originalSearchWriterMessageListeners;
        }

        public SearchEngine getSearchEngine() {
            return this._searchEngine;
        }

        public String getSearchReaderDestinationName() {
            return this._searchReaderDestinationName;
        }

        public String getSearchWriterDestinationName() {
            return this._searchWriterDestinationName;
        }

        public boolean isOverride() {
            return this._override;
        }

        public void setOriginalSearchEngineProxyWrapper(SearchEngineProxyWrapper searchEngineProxyWrapper) {
            this._originalSearchEngineProxyWrapper = searchEngineProxyWrapper;
        }

        public void setOverride(boolean override) {
            this._override = override;
        }

        public void setSearchReaderDestinationName(String searchReaderDestinationName) {
            this._searchReaderDestinationName = searchReaderDestinationName;
        }

        public void setSearchWriterDestinationName(String searchWriterDestinationName) {
            this._searchWriterDestinationName = searchWriterDestinationName;
        }
    }
}

