/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.BaseQueryImpl;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseBooleanQueryImpl
extends BaseQueryImpl
implements BooleanQuery {
    @Override
    public void addTerms(String[] fields, String values) throws ParseException {
        if (Validator.isNull(values)) {
            return;
        }
        if (fields == null) {
            fields = new String[]{};
        }
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            this.addTerm(field, values);
            ++n2;
        }
    }

    @Override
    public void addTerms(String[] fields, String value, boolean like) throws ParseException {
        if (Validator.isNull(value)) {
            return;
        }
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            this.addTerm(field, value, like);
            ++n2;
        }
    }

    protected void addTerms(String[] fields, Map<String, List<String>> termFieldsValuesMap) throws ParseException {
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            List<String> valuesList = termFieldsValuesMap.get(field);
            for (String value : valuesList) {
                this.addTerm(field, value);
            }
            ++n2;
        }
    }

    protected String getTermFieldRemainderValues(String field, String values, List<String> valuesList, String pattern, String replacement) {
        if (Validator.isNull(values)) {
            return values;
        }
        if (Validator.isNull(pattern) || Validator.isNull(replacement)) {
            return values;
        }
        field = Validator.isNotNull(field) ? String.valueOf(field) + ":" : "";
        while (values.matches(pattern)) {
            String value = values.replaceAll(pattern, replacement);
            valuesList.add(value);
            String duplicate = "(?i)\\s*" + Pattern.quote(String.valueOf(field) + value) + "\\s*";
            values = values.replaceAll(duplicate, " ");
            values = values.trim();
        }
        return values;
    }

    protected Map<String, List<String>> getTermFieldsValuesMap(String[] fields, String values) {
        HashMap<String, List<String>> termFieldsValuesMap = new HashMap<String, List<String>>();
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            ArrayList<String> valuesList = new ArrayList<String>();
            values = this.getTermFieldRemainderValues(field, values, valuesList, "(?i)^.*" + field + ":([\"'])(.+?)(\\1).*$", "$1$2$3");
            values = this.getTermFieldRemainderValues(field, values, valuesList, "(?i)^.*" + field + ":([^\\s\"']*).*$", "$1");
            termFieldsValuesMap.put(field, valuesList);
            ++n2;
        }
        values = values.trim();
        ArrayList<String> valuesList = new ArrayList<String>();
        if (Validator.isNotNull(values)) {
            values = this.getTermFieldRemainderValues(null, values, valuesList, "^[^\"']*([\"'])(.+?)(\\1)[^\"']*$", "$1$2$3");
            valuesList.add(values);
        }
        termFieldsValuesMap.put("no_field", valuesList);
        return termFieldsValuesMap;
    }

    protected String[] parseKeywords(String values) {
        if (!values.contains("\"")) {
            return StringUtil.split(values, ' ');
        }
        ArrayList<String> keywords = new ArrayList<String>();
        while (values.length() > 0) {
            int pos;
            if (values.startsWith("\"")) {
                if (!(values = values.substring(1)).contains("\"")) continue;
                pos = values.indexOf("\"");
                keywords.add(values.substring(0, pos));
                values = values.substring(pos + 1);
                values = values.trim();
                continue;
            }
            if (values.contains(" ")) {
                pos = values.indexOf(" ");
                keywords.add(values.substring(0, pos));
                values = values.substring(pos + 1);
                values = values.trim();
                continue;
            }
            keywords.add(values);
            break;
        }
        return keywords.toArray(new String[keywords.size()]);
    }
}

