/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryConfig
implements Serializable {
    public static final String LOCALE = "locale";
    private static final boolean _INDEX_SEARCH_HIGHLIGHT_ENABLED = GetterUtil.getBoolean(PropsUtil.get("index.search.highlight.enabled"));
    private static final int _INDEX_SEARCH_HIGHLIGHT_FRAGMENT_SIZE = GetterUtil.getInteger(PropsUtil.get("index.search.highlight.fragment.size"));
    private static final int _INDEX_SEARCH_HIGHLIGHT_SNIPPET_SIZE = GetterUtil.getInteger(PropsUtil.get("index.search.highlight.snippet.size"));
    private static final boolean _INDEX_SEARCH_SCORING_ENABLED = GetterUtil.getBoolean(PropsUtil.get("index.search.scoring.enabled"));
    private Map<String, Serializable> _attributes = new HashMap<String, Serializable>();

    public Serializable getAttribute(String name) {
        return this._attributes.get(name);
    }

    public Map<String, Serializable> getAttributes() {
        return this._attributes;
    }

    public int getHighlightFragmentSize() {
        return GetterUtil.getInteger(this._attributes.get("index.search.highlight.fragment.size"), _INDEX_SEARCH_HIGHLIGHT_FRAGMENT_SIZE);
    }

    public int getHighlightSnippetSize() {
        return GetterUtil.getInteger(this._attributes.get("index.search.highlight.snippet.size"), _INDEX_SEARCH_HIGHLIGHT_SNIPPET_SIZE);
    }

    public Locale getLocale() {
        Locale locale = (Locale)this._attributes.get(LOCALE);
        if (locale == null) {
            locale = LocaleUtil.getDefault();
        }
        return locale;
    }

    public boolean isHighlightEnabled() {
        return GetterUtil.getBoolean(this._attributes.get("index.search.highlight.enabled"), _INDEX_SEARCH_HIGHLIGHT_ENABLED);
    }

    public boolean isScoreEnabled() {
        return GetterUtil.getBoolean(this._attributes.get("index.search.scoring.enabled"), _INDEX_SEARCH_SCORING_ENABLED);
    }

    public Serializable removeAttribute(String name) {
        return this._attributes.remove(name);
    }

    public void setAttribute(String name, Serializable value) {
        this._attributes.put(name, value);
    }

    public void setHighlightEnabled(boolean highlightEnabled) {
        this._attributes.put("index.search.highlight.enabled", Boolean.valueOf(highlightEnabled));
    }

    public void setHighlightFragmentSize(int highlightFragmentSize) {
        this._attributes.put("index.search.highlight.fragment.size", Integer.valueOf(highlightFragmentSize));
    }

    public void setHighlightSnippetSize(int highlightSnippetSize) {
        this._attributes.put("index.search.highlight.snippet.size", Integer.valueOf(highlightSnippetSize));
    }

    public void setLocale(Locale locale) {
        this._attributes.put(LOCALE, locale);
    }

    public void setScoreEnabled(boolean scoreEnabled) {
        this._attributes.put("index.search.scoring.enabled", Boolean.valueOf(scoreEnabled));
    }
}

