/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchContext
implements Serializable {
    private boolean _andSearch;
    private long[] _assetCategoryIds;
    private String[] _assetTagNames;
    private Map<String, Serializable> _attributes;
    private BooleanClause[] _booleanClauses;
    private long[] _categoryIds;
    private long _companyId;
    private int _end = -1;
    private String[] _entryClassNames;
    private Map<String, Facet> _facets = new ConcurrentHashMap<String, Facet>();
    private long[] _folderIds;
    private long[] _groupIds;
    private boolean _includeLiveGroups = true;
    private boolean _includeStagingGroups = true;
    private String _keywords;
    private Locale _locale = LocaleUtil.getDefault();
    private long[] _nodeIds;
    private long _ownerUserId;
    private String[] _portletIds;
    private QueryConfig _queryConfig;
    private boolean _scopeStrict = true;
    private String _searchEngineId;
    private Sort[] _sorts;
    private int _start = -1;
    private TimeZone _timeZone;
    private long _userId;

    public void addFacet(Facet facet) {
        if (facet == null) {
            return;
        }
        this._facets.put(facet.getFieldName(), facet);
    }

    public long[] getAssetCategoryIds() {
        return this._assetCategoryIds;
    }

    public String[] getAssetTagNames() {
        return this._assetTagNames;
    }

    public Serializable getAttribute(String name) {
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.get(name);
    }

    public Map<String, Serializable> getAttributes() {
        if (this._attributes == null) {
            this._attributes = new HashMap<String, Serializable>();
        }
        return this._attributes;
    }

    public BooleanClause[] getBooleanClauses() {
        return this._booleanClauses;
    }

    public long[] getCategoryIds() {
        return this._categoryIds;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public int getEnd() {
        return this._end;
    }

    public String[] getEntryClassNames() {
        if (this._entryClassNames == null) {
            this._entryClassNames = new String[0];
        }
        return this._entryClassNames;
    }

    public Facet getFacet(String fieldName) {
        return this._facets.get(fieldName);
    }

    public Map<String, Facet> getFacets() {
        return this._facets;
    }

    public long[] getFolderIds() {
        return this._folderIds;
    }

    public long[] getGroupIds() {
        return this._groupIds;
    }

    public String getKeywords() {
        return this._keywords;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public long[] getNodeIds() {
        return this._nodeIds;
    }

    public long getOwnerUserId() {
        return this._ownerUserId;
    }

    public String[] getPortletIds() {
        return this._portletIds;
    }

    public QueryConfig getQueryConfig() {
        if (this._queryConfig == null) {
            this._queryConfig = new QueryConfig();
        }
        return this._queryConfig;
    }

    public String getSearchEngineId() {
        if (Validator.isNull(this._searchEngineId)) {
            return "SYSTEM_ENGINE";
        }
        return this._searchEngineId;
    }

    public Sort[] getSorts() {
        return this._sorts;
    }

    public int getStart() {
        return this._start;
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public long getUserId() {
        return this._userId;
    }

    public boolean isAndSearch() {
        return this._andSearch;
    }

    public boolean isIncludeLiveGroups() {
        return this._includeLiveGroups;
    }

    public boolean isIncludeStagingGroups() {
        return this._includeStagingGroups;
    }

    public boolean isScopeStrict() {
        return this._scopeStrict;
    }

    public void setAndSearch(boolean andSearch) {
        this._andSearch = andSearch;
    }

    public void setAssetCategoryIds(long[] assetCategoryIds) {
        this._assetCategoryIds = assetCategoryIds;
    }

    public void setAssetTagNames(String[] assetTagNames) {
        this._assetTagNames = assetTagNames;
    }

    public void setAttribute(String name, Serializable value) {
        if (this._attributes == null) {
            this._attributes = new HashMap<String, Serializable>();
        }
        this._attributes.put(name, value);
    }

    public void setAttributes(Map<String, Serializable> attributes) {
        this._attributes = attributes;
    }

    public void setBooleanClauses(BooleanClause[] booleanClauses) {
        this._booleanClauses = booleanClauses;
    }

    public void setCategoryIds(long[] categoryIds) {
        this._categoryIds = categoryIds;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public void setEnd(int end) {
        this._end = end;
    }

    public void setEntryClassNames(String[] entryClassNames) {
        this._entryClassNames = entryClassNames;
    }

    public void setFacets(List<Facet> facets) {
        for (Facet facet : facets) {
            this._facets.put(facet.getFieldName(), facet);
        }
    }

    public void setFolderIds(long[] folderIds) {
        this._folderIds = folderIds;
    }

    public void setGroupIds(long[] groupIds) {
        this._groupIds = groupIds;
    }

    public void setIncludeLiveGroups(boolean includeLiveGroups) {
        this._includeLiveGroups = includeLiveGroups;
    }

    public void setIncludeStagingGroups(boolean includeStagingGroups) {
        this._includeStagingGroups = includeStagingGroups;
    }

    public void setKeywords(String keywords) {
        this._keywords = keywords;
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this._locale = locale;
        }
    }

    public void setNodeIds(long[] nodeIds) {
        this._nodeIds = nodeIds;
    }

    public void setQueryConfig(QueryConfig queryConfig) {
        this._queryConfig = queryConfig;
    }

    public void setOwnerUserId(long ownerUserId) {
        this._ownerUserId = ownerUserId;
    }

    public void setPortletIds(String[] portletIds) {
        this._portletIds = portletIds;
    }

    public void setScopeStrict(boolean scopeStrict) {
        this._scopeStrict = scopeStrict;
    }

    public void setSearchEngineId(String searchEngineId) {
        if (this._searchEngineId == null) {
            this._searchEngineId = searchEngineId;
        }
    }

    public void setSorts(Sort[] sorts) {
        this._sorts = sorts;
    }

    public void setStart(int start) {
        this._start = start;
    }

    public void setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone;
    }

    public void setUserId(long userId) {
        this._userId = userId;
    }
}

