/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.facet;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.facet.MultiValueFacet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;

public class AssetEntriesFacet
extends MultiValueFacet {
    private static Log _log = LogFactoryUtil.getLog(AssetEntriesFacet.class);

    public AssetEntriesFacet(SearchContext searchContext) {
        super(searchContext);
        this.setFieldName("entryClassName");
        this.initFacetClause();
    }

    public void setFacetConfiguration(FacetConfiguration facetConfiguration) {
        super.setFacetConfiguration(facetConfiguration);
        this.initFacetClause();
    }

    protected BooleanClause doGetFacetClause() {
        SearchContext searchContext = this.getSearchContext();
        String[] entryClassNames = searchContext.getEntryClassNames();
        BooleanQuery facetQuery = BooleanQueryFactoryUtil.create(searchContext);
        String[] stringArray = entryClassNames;
        int n = entryClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String entryClassName = stringArray[n2];
            Indexer indexer = IndexerRegistryUtil.getIndexer(entryClassName);
            if (indexer != null) {
                try {
                    BooleanQuery indexerBooleanQuery = indexer.getFacetQuery(entryClassName, searchContext);
                    if (indexerBooleanQuery != null && indexerBooleanQuery.hasClauses()) {
                        BooleanQuery entityQuery = BooleanQueryFactoryUtil.create(searchContext);
                        entityQuery.add((Query)indexerBooleanQuery, BooleanClauseOccur.MUST);
                        indexer.postProcessContextQuery(entityQuery, searchContext);
                        IndexerPostProcessor[] indexerPostProcessorArray = indexer.getIndexerPostProcessors();
                        int n3 = indexerPostProcessorArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IndexerPostProcessor indexerPostProcessor = indexerPostProcessorArray[n4];
                            indexerPostProcessor.postProcessContextQuery(entityQuery, searchContext);
                            ++n4;
                        }
                        if (indexer.isStagingAware()) {
                            if (!searchContext.isIncludeLiveGroups() && searchContext.isIncludeStagingGroups()) {
                                entityQuery.addRequiredTerm("stagingGroup", true);
                            } else if (searchContext.isIncludeLiveGroups() && !searchContext.isIncludeStagingGroups()) {
                                entityQuery.addRequiredTerm("stagingGroup", false);
                            }
                        }
                        if (entityQuery.hasClauses()) {
                            facetQuery.add((Query)entityQuery, BooleanClauseOccur.SHOULD);
                        }
                    }
                }
                catch (Exception e) {
                    _log.error(e, e);
                }
            }
            ++n2;
        }
        if (!facetQuery.hasClauses()) {
            return null;
        }
        return BooleanClauseFactoryUtil.create(facetQuery, BooleanClauseOccur.MUST.getName());
    }

    protected void initFacetClause() {
        String[] entryClassNameParam;
        SearchContext searchContext = this.getSearchContext();
        FacetConfiguration facetConfiguration = this.getFacetConfiguration();
        JSONObject dataJSONObject = facetConfiguration.getData();
        String[] entryClassNames = null;
        if (dataJSONObject.has("values")) {
            JSONArray valuesJSONArray = dataJSONObject.getJSONArray("values");
            entryClassNames = new String[valuesJSONArray.length()];
            int i = 0;
            while (i < valuesJSONArray.length()) {
                entryClassNames[i] = valuesJSONArray.getString(i);
                ++i;
            }
        }
        if (entryClassNames == null || entryClassNames.length == 0) {
            entryClassNames = searchContext.getEntryClassNames();
        }
        if (!this.isStatic() && (entryClassNameParam = StringUtil.split(GetterUtil.getString(searchContext.getAttribute(this.getFieldName())))) != null && entryClassNameParam.length > 0) {
            entryClassNames = entryClassNameParam;
        }
        if (entryClassNames == null || entryClassNames.length == 0) {
            entryClassNames = SearchEngineUtil.getEntryClassNames();
            if (!dataJSONObject.has("values")) {
                JSONArray entriesJSONArray = JSONFactoryUtil.createJSONArray();
                String[] stringArray = entryClassNames;
                int n = entryClassNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String entryClassName = stringArray[n2];
                    entriesJSONArray.put(entryClassName);
                    ++n2;
                }
                dataJSONObject.put("values", entriesJSONArray);
            }
        }
        searchContext.setEntryClassNames(entryClassNames);
    }
}

