/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.facet;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.TermRangeQuery;
import com.liferay.portal.kernel.search.TermRangeQueryFactoryUtil;
import com.liferay.portal.kernel.search.facet.BaseFacet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.search.facet.util.RangeParserUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;

public class RangeFacet
extends BaseFacet {
    public RangeFacet(SearchContext searchContext) {
        super(searchContext);
    }

    protected BooleanClause doGetFacetClause() {
        String[] range;
        SearchContext searchContext = this.getSearchContext();
        FacetConfiguration facetConfiguration = this.getFacetConfiguration();
        JSONObject dataJSONObject = facetConfiguration.getData();
        String start = "";
        String end = "";
        if (this.isStatic() && dataJSONObject.has("ranges")) {
            JSONArray rangesJSONArray = dataJSONObject.getJSONArray("ranges");
            String rangeString = rangesJSONArray.getString(0);
            range = RangeParserUtil.parserRange(rangeString);
            start = range[0];
            end = range[1];
        }
        String fieldName = this.getFieldName();
        String rangeParam = GetterUtil.getString(searchContext.getAttribute(fieldName));
        if (!this.isStatic() && Validator.isNotNull(rangeParam)) {
            range = RangeParserUtil.parserRange(rangeParam);
            start = range[0];
            end = range[1];
        }
        if (Validator.isNull(start) && Validator.isNull(end)) {
            return null;
        }
        if (Validator.isNotNull(start) && Validator.isNotNull(end) && start.compareTo(end) >= 0) {
            throw new IllegalArgumentException("End value must be greater than start value");
        }
        String startString = "*";
        if (Validator.isNotNull(start)) {
            startString = start;
        }
        String endString = "*";
        if (Validator.isNotNull(end)) {
            endString = end;
        }
        TermRangeQuery facetTermRangeQuery = TermRangeQueryFactoryUtil.create(searchContext, fieldName, startString, endString, true, true);
        return BooleanClauseFactoryUtil.create(facetTermRangeQuery, BooleanClauseOccur.MUST.getName());
    }
}

