/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.DirectRequestDispatcher;
import com.liferay.portal.kernel.servlet.DirectServletRegistry;
import com.liferay.portal.kernel.util.ContextPathUtil;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectServletContext
implements ServletContext {
    private static Log _log = LogFactoryUtil.getLog(DirectServletContext.class);
    private String _contextPath;
    private ServletContext _servletContext;

    public DirectServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
        this._contextPath = ContextPathUtil.getContextPath(servletContext);
    }

    public Object getAttribute(String name) {
        return this._servletContext.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this._servletContext.getAttributeNames();
    }

    public ServletContext getContext(String uriPath) {
        return this._servletContext.getContext(uriPath);
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getInitParameter(String name) {
        return this._servletContext.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this._servletContext.getInitParameterNames();
    }

    public int getMajorVersion() {
        return this._servletContext.getMajorVersion();
    }

    public String getMimeType(String file) {
        return this._servletContext.getMimeType(file);
    }

    public int getMinorVersion() {
        return this._servletContext.getMinorVersion();
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this._servletContext.getNamedDispatcher(name);
    }

    public String getRealPath(String path) {
        return this._servletContext.getRealPath(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        String fullPath = this._contextPath.concat(path);
        Servlet servlet = DirectServletRegistry.getServlet(fullPath);
        if (servlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No servlet found for " + fullPath);
            }
            return this._servletContext.getRequestDispatcher(path);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Servlet found for " + fullPath);
        }
        return new DirectRequestDispatcher(servlet);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this._servletContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this._servletContext.getResourceAsStream(path);
    }

    public Set<String> getResourcePaths(String path) {
        return this._servletContext.getResourcePaths(path);
    }

    public String getServerInfo() {
        return this._servletContext.getServerInfo();
    }

    public Servlet getServlet(String name) throws ServletException {
        return this._servletContext.getServlet(name);
    }

    public String getServletContextName() {
        return this._servletContext.getServletContextName();
    }

    public Enumeration<String> getServletNames() {
        return this._servletContext.getServletNames();
    }

    public Enumeration<Servlet> getServlets() {
        return this._servletContext.getServlets();
    }

    public void log(Exception exception, String message) {
        this._servletContext.log(exception, message);
    }

    public void log(String message) {
        this._servletContext.log(message);
    }

    public void log(String message, Throwable t) {
        this._servletContext.log(message, t);
    }

    public void removeAttribute(String name) {
        this._servletContext.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this._servletContext.setAttribute(name, value);
    }
}

