/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.JasperVersionDetector;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public class DirectServletRegistry {
    private static final boolean _DIRECT_SERVLET_CONTEXT_RELOAD = GetterUtil.getBoolean(PropsUtil.get("direct.servlet.context.reload"));
    private static Log _log = LogFactoryUtil.getLog(DirectServletRegistry.class);
    private static DirectServletRegistry _instance = new DirectServletRegistry();
    private static boolean _reloadDependents = true;
    private Map<String, ServletInfo> _servletInfos = new ConcurrentHashMap<String, ServletInfo>();

    public static void clearServlets() {
        _instance._clearServlets();
    }

    public static Servlet getServlet(String path) {
        return _instance._getServlet(path);
    }

    public static void putServlet(String path, Servlet servlet) {
        _instance._putServlet(path, servlet);
    }

    private DirectServletRegistry() {
    }

    private void _clearServlets() {
        this._servletInfos.clear();
    }

    private long _getFileLastModified(String path, Servlet servlet) {
        ServletConfig servletConfig = servlet.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        String rootPath = servletContext.getRealPath("");
        File file = new File(rootPath, path);
        return file.lastModified();
    }

    private Servlet _getServlet(String path) {
        ServletInfo servletInfo = this._servletInfos.get(path);
        if (servletInfo == null) {
            return null;
        }
        Servlet servlet = servletInfo.getServlet();
        if (_DIRECT_SERVLET_CONTEXT_RELOAD) {
            long lastModified = this._getFileLastModified(path, servlet);
            if (lastModified == 0L || lastModified > servletInfo.getLastModified()) {
                this._servletInfos.remove(path);
                servlet = null;
                if (_log.isDebugEnabled()) {
                    _log.debug("Reload " + path);
                }
            } else {
                servlet = this._reloadDependents(path, servlet, servletInfo);
            }
        }
        return servlet;
    }

    private void _putServlet(String path, Servlet servlet) {
        if (this._servletInfos.containsKey(path)) {
            return;
        }
        long lastModified = 1L;
        if (_DIRECT_SERVLET_CONTEXT_RELOAD) {
            lastModified = this._getFileLastModified(path, servlet);
        }
        if (lastModified > 0L) {
            ServletInfo servletInfo = new ServletInfo();
            servletInfo.setLastModified(lastModified);
            servletInfo.setServlet(servlet);
            this._servletInfos.put(path, servletInfo);
        }
    }

    private Servlet _reloadDependents(String path, Servlet servlet, ServletInfo servletInfo) {
        try {
            if (!_reloadDependents) {
                return servlet;
            }
            Method method = ReflectionUtil.getDeclaredMethod(servlet.getClass(), "getDependants", new Class[0]);
            Collection<Object> dependants = null;
            String jasperVersion = JasperVersionDetector.getJasperVersion();
            if (jasperVersion.contains("7.0")) {
                Map dependantsMap = (Map)method.invoke((Object)servlet, new Object[0]);
                if (dependantsMap != null) {
                    dependants = dependantsMap.keySet();
                }
            } else {
                dependants = (List)method.invoke((Object)servlet, new Object[0]);
            }
            if (dependants == null) {
                return servlet;
            }
            for (String dependant : dependants) {
                long lastModified = this._getFileLastModified(dependant, servlet);
                if (lastModified != 0L && lastModified <= servletInfo.getLastModified()) continue;
                this._servletInfos.remove(path);
                this._updateFileLastModified(path, servlet);
                servlet = null;
                if (_log.isDebugEnabled()) {
                    _log.debug("Reload dependent " + dependant);
                }
                break;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (_log.isWarnEnabled()) {
                _log.warn("Reloading of dependant JSP is disabled because your Servlet container is not a variant of Jasper");
            }
            _reloadDependents = false;
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return servlet;
    }

    private void _updateFileLastModified(String path, Servlet servlet) {
        ServletConfig servletConfig = servlet.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        String rootPath = servletContext.getRealPath("");
        File file = new File(rootPath, path);
        file.setLastModified(System.currentTimeMillis());
    }

    private class ServletInfo {
        private long _lastModified;
        private Servlet _servlet;

        private ServletInfo() {
        }

        public long getLastModified() {
            return this._lastModified;
        }

        public Servlet getServlet() {
            return this._servlet;
        }

        public void setLastModified(long lastModified) {
            this._lastModified = lastModified;
        }

        public void setServlet(Servlet servlet) {
            this._servlet = servlet;
        }
    }
}

