/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContextPool {
    private static Log _log = LogFactoryUtil.getLog(ServletContextPool.class);
    private static ServletContextPool _instance = new ServletContextPool();
    private Map<String, ServletContext> _servletContexts = new ConcurrentHashMap<String, ServletContext>();

    public static void clear() {
        ServletContextPool._instance._servletContexts.clear();
    }

    public static boolean containsKey(String servletContextName) {
        return _instance._containsKey(servletContextName);
    }

    public static ServletContext get(String servletContextName) {
        return _instance._get(servletContextName);
    }

    public static Set<String> keySet() {
        return _instance._keySet();
    }

    public static void put(String servletContextName, ServletContext servletContext) {
        _instance._put(servletContextName, servletContext);
    }

    public static ServletContext remove(String servletContextName) {
        return _instance._remove(servletContextName);
    }

    private ServletContextPool() {
    }

    private boolean _containsKey(String servletContextName) {
        if (servletContextName == null) {
            return false;
        }
        boolean value = this._servletContexts.containsKey(servletContextName);
        if (_log.isDebugEnabled()) {
            _log.debug("Contains key " + servletContextName + " " + value);
        }
        return value;
    }

    private ServletContext _get(String servletContextName) {
        ServletContext servletContext = this._servletContexts.get(servletContextName);
        if (_log.isDebugEnabled()) {
            _log.debug("Get " + servletContextName + " " + servletContext);
        }
        return servletContext;
    }

    private Set<String> _keySet() {
        return this._servletContexts.keySet();
    }

    private void _put(String servletContextName, ServletContext servletContext) {
        if (_log.isDebugEnabled()) {
            _log.debug("Put " + servletContextName + " " + servletContext);
        }
        this._servletContexts.put(servletContextName, servletContext);
    }

    private ServletContext _remove(String servletContextName) {
        ServletContext servletContext = this._servletContexts.remove(servletContextName);
        if (_log.isDebugEnabled()) {
            _log.debug("Remove " + servletContextName + " " + servletContext);
        }
        return servletContext;
    }
}

