/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.filters.invoker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.filters.invoker.Dispatcher;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterMapping {
    private static final String _SLASH_STAR = "/*";
    private static final String _STAR_PERIOD = "*.";
    private static Log _log = LogFactoryUtil.getLog(FilterMapping.class);
    private boolean _dispatcherError;
    private boolean _dispatcherForward;
    private boolean _dispatcherInclude;
    private boolean _dispatcherRequest;
    private Filter _filter;
    private List<String> _urlPatterns;
    private Pattern _urlRegexIgnorePattern;
    private Pattern _urlRegexPattern;

    public FilterMapping(Filter filter, FilterConfig filterConfig, List<String> urlPatterns, List<String> dispatchers) {
        this._filter = filter;
        this._urlPatterns = urlPatterns;
        this.initFilterConfig(filterConfig);
        this.initDispatchers(dispatchers);
    }

    public Filter getFilter() {
        return this._filter;
    }

    public boolean isMatch(HttpServletRequest request, Dispatcher dispatcher, String uri) {
        if (!this.isMatchDispatcher(dispatcher)) {
            return false;
        }
        boolean matchURLPattern = false;
        for (String urlPattern : this._urlPatterns) {
            if (!this.isMatchURLPattern(uri, urlPattern)) continue;
            matchURLPattern = true;
            break;
        }
        if (_log.isDebugEnabled()) {
            if (matchURLPattern) {
                _log.debug(this._filter.getClass() + " has a pattern match with " + uri);
            } else {
                _log.debug(this._filter.getClass() + " does not have a pattern match with " + uri);
            }
        }
        if (!matchURLPattern) {
            return false;
        }
        return this.isMatchURLRegexPattern(request, uri);
    }

    public void setFilter(Filter filter) {
        this._filter = filter;
    }

    protected void initDispatchers(List<String> dispatchers) {
        for (String dispatcher : dispatchers) {
            if (dispatcher.equals("ERROR")) {
                this._dispatcherError = true;
                continue;
            }
            if (dispatcher.equals("FORWARD")) {
                this._dispatcherForward = true;
                continue;
            }
            if (dispatcher.equals("INCLUDE")) {
                this._dispatcherInclude = true;
                continue;
            }
            if (dispatcher.equals("REQUEST")) {
                this._dispatcherRequest = true;
                continue;
            }
            throw new IllegalArgumentException("Invalid dispatcher " + dispatcher);
        }
        if (!(this._dispatcherError || this._dispatcherForward || this._dispatcherInclude || this._dispatcherRequest)) {
            this._dispatcherRequest = true;
        }
    }

    protected void initFilterConfig(FilterConfig filterConfig) {
        String urlRegexIgnorePattern;
        String urlRegexPattern = GetterUtil.getString(filterConfig.getInitParameter("url-regex-pattern"));
        if (Validator.isNotNull(urlRegexPattern)) {
            this._urlRegexPattern = Pattern.compile(urlRegexPattern);
        }
        if (Validator.isNotNull(urlRegexIgnorePattern = GetterUtil.getString(filterConfig.getInitParameter("url-regex-ignore-pattern")))) {
            this._urlRegexIgnorePattern = Pattern.compile(urlRegexIgnorePattern);
        }
    }

    protected boolean isMatchDispatcher(Dispatcher dispatcher) {
        return dispatcher == Dispatcher.ERROR && this._dispatcherError || dispatcher == Dispatcher.FORWARD && this._dispatcherForward || dispatcher == Dispatcher.INCLUDE && this._dispatcherInclude || dispatcher == Dispatcher.REQUEST && this._dispatcherRequest;
    }

    protected boolean isMatchURLPattern(String uri, String urlPattern) {
        if (urlPattern.equals(uri)) {
            return true;
        }
        if (urlPattern.equals(_SLASH_STAR)) {
            return true;
        }
        if (urlPattern.endsWith(_SLASH_STAR)) {
            if (urlPattern.regionMatches(0, uri, 0, urlPattern.length() - 2)) {
                if (uri.length() == urlPattern.length() - 2) {
                    return true;
                }
                if ('/' == uri.charAt(urlPattern.length() - 2)) {
                    return true;
                }
            }
        } else if (urlPattern.startsWith(_STAR_PERIOD)) {
            int slashPos = uri.lastIndexOf(47);
            int periodPos = uri.lastIndexOf(46);
            if (slashPos >= 0 && periodPos > slashPos && periodPos != uri.length() - 1 && uri.length() - periodPos == urlPattern.length() - 1 && urlPattern.regionMatches(2, uri, periodPos + 1, urlPattern.length() - 2)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isMatchURLRegexPattern(HttpServletRequest request, String uri) {
        Matcher matcher;
        String url = uri;
        String queryString = request.getQueryString();
        if (Validator.isNotNull(queryString)) {
            url = url.concat("?").concat(queryString);
        }
        boolean matchURLRegexPattern = true;
        if (this._urlRegexPattern != null) {
            matcher = this._urlRegexPattern.matcher(url);
            matchURLRegexPattern = matcher.find();
        }
        if (matchURLRegexPattern && this._urlRegexIgnorePattern != null) {
            matcher = this._urlRegexIgnorePattern.matcher(url);
            boolean bl = matchURLRegexPattern = !matcher.find();
        }
        if (_log.isDebugEnabled()) {
            if (matchURLRegexPattern) {
                _log.debug(this._filter.getClass() + " has a regex match with " + url);
            } else {
                _log.debug(this._filter.getClass() + " does not have a regex match with " + url);
            }
        }
        return matchURLRegexPattern;
    }
}

