/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.filters.invoker;

import com.liferay.portal.kernel.concurrent.ConcurrentLRUCache;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.filters.invoker.Dispatcher;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilterChain;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilterHelper;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class InvokerFilter
extends BasePortalLifecycle
implements Filter {
    private static Log _log = LogFactoryUtil.getLog(InvokerFilter.class);
    private String _contextPath;
    private Dispatcher _dispatcher;
    private ConcurrentLRUCache<Integer, InvokerFilterChain> _filterChains;
    private FilterConfig _filterConfig;
    private int _invokerFilterChainSize;
    private InvokerFilterHelper _invokerFilterHelper;

    public void destroy() {
        this.portalDestroy();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String uri = this.getURI(request);
        request.setAttribute("INVOKER_FILTER_URI", (Object)uri);
        InvokerFilterChain invokerFilterChain = this.getInvokerFilterChain(request, uri, filterChain);
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        invokerFilterChain.setContextClassLoader(contextClassLoader);
        invokerFilterChain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this._filterConfig = filterConfig;
        ServletContext servletContext = this._filterConfig.getServletContext();
        this._contextPath = servletContext.getContextPath();
        boolean registerPortalLifecycle = GetterUtil.getBoolean(this._filterConfig.getInitParameter("register-portal-lifecycle"), true);
        if (registerPortalLifecycle) {
            this.registerPortalLifecycle();
        } else {
            try {
                this.doPortalInit();
            }
            catch (Exception e) {
                _log.error(e, e);
                throw new ServletException((Throwable)e);
            }
        }
    }

    protected void clearFilterChainsCache() {
        if (this._filterChains != null) {
            this._filterChains.clear();
        }
    }

    protected void doPortalDestroy() {
        ServletContext servletContext = this._filterConfig.getServletContext();
        InvokerFilterHelper invokerFilterHelper = (InvokerFilterHelper)servletContext.getAttribute(InvokerFilterHelper.class.getName());
        if (invokerFilterHelper != null) {
            servletContext.removeAttribute(InvokerFilterHelper.class.getName());
            this._invokerFilterHelper.destroy();
        }
    }

    protected void doPortalInit() throws Exception {
        ServletContext servletContext;
        InvokerFilterHelper invokerFilterHelper;
        this._invokerFilterChainSize = GetterUtil.getInteger(PropsUtil.get("invoker.filter.chain.cache.size"));
        if (this._invokerFilterChainSize > 0) {
            this._filterChains = new ConcurrentLRUCache(this._invokerFilterChainSize);
        }
        if ((invokerFilterHelper = (InvokerFilterHelper)(servletContext = this._filterConfig.getServletContext()).getAttribute(InvokerFilterHelper.class.getName())) == null) {
            invokerFilterHelper = new InvokerFilterHelper();
            servletContext.setAttribute(InvokerFilterHelper.class.getName(), (Object)invokerFilterHelper);
            invokerFilterHelper.readLiferayFilterWebXML(servletContext, "/WEB-INF/liferay-web.xml");
        }
        this._invokerFilterHelper = invokerFilterHelper;
        this._invokerFilterHelper.addInvokerFilter(this);
        String dispatcher = GetterUtil.getString(this._filterConfig.getInitParameter("dispatcher"));
        if (dispatcher.equals("ERROR")) {
            this._dispatcher = Dispatcher.ERROR;
        } else if (dispatcher.equals("FORWARD")) {
            this._dispatcher = Dispatcher.FORWARD;
        } else if (dispatcher.equals("INCLUDE")) {
            this._dispatcher = Dispatcher.INCLUDE;
        } else if (dispatcher.equals("REQUEST")) {
            this._dispatcher = Dispatcher.REQUEST;
        } else {
            throw new IllegalArgumentException("Invalid dispatcher " + dispatcher);
        }
    }

    protected InvokerFilterChain getInvokerFilterChain(HttpServletRequest request, String uri, FilterChain filterChain) {
        if (this._filterChains == null) {
            return this._invokerFilterHelper.createInvokerFilterChain(request, this._dispatcher, uri, filterChain);
        }
        Integer key = uri.hashCode();
        InvokerFilterChain invokerFilterChain = this._filterChains.get(key);
        if (invokerFilterChain == null) {
            invokerFilterChain = this._invokerFilterHelper.createInvokerFilterChain(request, this._dispatcher, uri, filterChain);
            this._filterChains.put(key, invokerFilterChain);
        }
        return invokerFilterChain.clone(filterChain);
    }

    protected String getURI(HttpServletRequest request) {
        String uri = null;
        uri = this._dispatcher == Dispatcher.ERROR ? (String)request.getAttribute("javax.servlet.error.request_uri") : (this._dispatcher == Dispatcher.INCLUDE ? (String)request.getAttribute("javax.servlet.include.request_uri") : request.getRequestURI());
        if (Validator.isNotNull(this._contextPath) && !this._contextPath.equals("/") && uri.startsWith(this._contextPath)) {
            uri = uri.substring(this._contextPath.length());
        }
        return uri;
    }
}

