/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.filters.invoker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.LiferayFilter;
import com.liferay.portal.kernel.servlet.filters.invoker.Dispatcher;
import com.liferay.portal.kernel.servlet.filters.invoker.FilterMapping;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilter;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilterChain;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilterConfig;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.PortalLifecycle;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokerFilterHelper {
    private static Log _log = LogFactoryUtil.getLog(InvokerFilter.class);
    private Map<String, FilterConfig> _filterConfigs = new HashMap<String, FilterConfig>();
    private List<FilterMapping> _filterMappings = new CopyOnWriteArrayList<FilterMapping>();
    private Map<String, Filter> _filters = new HashMap<String, Filter>();
    private List<InvokerFilter> _invokerFilters = new ArrayList<InvokerFilter>();

    public void destroy() {
        for (Map.Entry<String, Filter> entry : this._filters.entrySet()) {
            Filter filter = entry.getValue();
            try {
                filter.destroy();
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
        this._filterConfigs.clear();
        this._filterMappings.clear();
        this._filters.clear();
        for (InvokerFilter invokerFilter : this._invokerFilters) {
            invokerFilter.clearFilterChainsCache();
        }
    }

    public Filter getFilter(String filterName) {
        return this._filters.get(filterName);
    }

    public FilterConfig getFilterConfig(String filterName) {
        return this._filterConfigs.get(filterName);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            ServletContext servletContext = filterConfig.getServletContext();
            this.readLiferayFilterWebXML(servletContext, "/WEB-INF/liferay-web.xml");
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new ServletException((Throwable)e);
        }
    }

    public Filter registerFilter(String filterName, Filter filter) {
        Filter previousFilter = this._filters.put(filterName, filter);
        if (previousFilter != null) {
            for (FilterMapping filterMapping : this._filterMappings) {
                if (filterMapping.getFilter() != previousFilter) continue;
                if (filter != null) {
                    filterMapping.setFilter(filter);
                    continue;
                }
                this._filterMappings.remove(filterMapping);
                this._filterConfigs.remove(filterName);
            }
        }
        for (InvokerFilter invokerFilter : this._invokerFilters) {
            invokerFilter.clearFilterChainsCache();
        }
        return previousFilter;
    }

    public void registerFilterMapping(FilterMapping filterMapping, String filterName, boolean after) {
        Filter filter;
        int i = 0;
        if (Validator.isNotNull(filterName) && (filter = this._filters.get(filterName)) != null) {
            while (i < this._filterMappings.size()) {
                FilterMapping currentFilterMapping = this._filterMappings.get(i);
                if (currentFilterMapping.getFilter() == filter) break;
                ++i;
            }
        }
        if (after) {
            ++i;
        }
        this._filterMappings.add(i, filterMapping);
        for (InvokerFilter invokerFilter : this._invokerFilters) {
            invokerFilter.clearFilterChainsCache();
        }
    }

    public void unregisterFilterMapping(FilterMapping filterMapping) {
        this._filterMappings.remove(filterMapping);
        for (InvokerFilter invokerFilter : this._invokerFilters) {
            invokerFilter.clearFilterChainsCache();
        }
    }

    protected void addInvokerFilter(InvokerFilter invokerFilter) {
        this._invokerFilters.add(invokerFilter);
    }

    protected InvokerFilterChain createInvokerFilterChain(HttpServletRequest request, Dispatcher dispatcher, String uri, FilterChain filterChain) {
        InvokerFilterChain invokerFilterChain = new InvokerFilterChain(filterChain);
        for (FilterMapping filterMapping : this._filterMappings) {
            if (!filterMapping.isMatch(request, dispatcher, uri)) continue;
            Filter filter = filterMapping.getFilter();
            invokerFilterChain.addFilter(filter);
        }
        return invokerFilterChain;
    }

    protected void initFilter(ServletContext servletContext, String filterName, String filterClassName, Map<String, String> initParameterMap) throws Exception {
        ClassLoader contextClassLoader = (ClassLoader)servletContext.getAttribute("PORTLET_CLASS_LOADER");
        if (contextClassLoader == null) {
            Thread currentThread = Thread.currentThread();
            contextClassLoader = currentThread.getContextClassLoader();
        }
        Filter filter = (Filter)InstanceFactory.newInstance(contextClassLoader, filterClassName);
        InvokerFilterConfig filterConfig = new InvokerFilterConfig(servletContext, filterName, initParameterMap);
        filter.init((FilterConfig)filterConfig);
        boolean filterEnabled = true;
        if (filter instanceof LiferayFilter) {
            LiferayFilter liferayFilter = (LiferayFilter)filter;
            filterEnabled = liferayFilter.isFilterEnabled();
        }
        if (filterEnabled) {
            this._filterConfigs.put(filterName, filterConfig);
            this._filters.put(filterName, filter);
        } else {
            if (filter instanceof PortalLifecycle) {
                PortalLifecycle portalLifecycle = (PortalLifecycle)filter;
                PortalLifecycleUtil.removeDestroy(portalLifecycle);
            }
            if (_log.isDebugEnabled()) {
                _log.debug("Removing disabled filter " + filter.getClass());
            }
        }
    }

    protected void initFilterMapping(String filterName, List<String> urlPatterns, List<String> dispatchers) {
        Filter filter = this._filters.get(filterName);
        if (filter == null) {
            return;
        }
        FilterConfig filterConfig = this._filterConfigs.get(filterName);
        if (filterConfig == null) {
            return;
        }
        FilterMapping filterMapping = new FilterMapping(filter, filterConfig, urlPatterns, dispatchers);
        this._filterMappings.add(filterMapping);
    }

    protected void readLiferayFilterWebXML(ServletContext servletContext, String path) throws Exception {
        InputStream inputStream = servletContext.getResourceAsStream(path);
        if (inputStream == null) {
            return;
        }
        Document document = SAXReaderUtil.read(inputStream, true);
        Element rootElement = document.getRootElement();
        List<Element> filterElements = rootElement.elements("filter");
        for (Element filterElement : filterElements) {
            String filterName = filterElement.elementText("filter-name");
            String filterClassName = filterElement.elementText("filter-class");
            HashMap<String, String> initParameterMap = new HashMap<String, String>();
            List<Element> initParamElements = filterElement.elements("init-param");
            for (Element initParamElement : initParamElements) {
                String name = initParamElement.elementText("param-name");
                String value = initParamElement.elementText("param-value");
                initParameterMap.put(name, value);
            }
            this.initFilter(servletContext, filterName, filterClassName, initParameterMap);
        }
        List<Element> filterMappingElements = rootElement.elements("filter-mapping");
        for (Element filterMappingElement : filterMappingElements) {
            String filterName = filterMappingElement.elementText("filter-name");
            ArrayList<String> urlPatterns = new ArrayList<String>();
            List<Element> urlPatternElements = filterMappingElement.elements("url-pattern");
            for (Element urlPatternElement : urlPatternElements) {
                urlPatterns.add(urlPatternElement.getTextTrim());
            }
            ArrayList<String> dispatchers = new ArrayList<String>(4);
            List<Element> dispatcherElements = filterMappingElement.elements("dispatcher");
            for (Element dispatcherElement : dispatcherElements) {
                String dispatcher = dispatcherElement.getTextTrim().toUpperCase();
                dispatchers.add(dispatcher);
            }
            this.initFilterMapping(filterName, urlPatterns, dispatchers);
        }
    }
}

