/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.taglib;

import com.liferay.portal.kernel.util.Validator;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

public class FileAvailabilityUtil {
    private static Map<String, Boolean> _availabilities = new ConcurrentHashMap<String, Boolean>();

    public static boolean isAvailable(ServletContext servletContext, String path) {
        if (Validator.isNull(path)) {
            return false;
        }
        if (path.charAt(0) != '/') {
            return true;
        }
        Boolean available = _availabilities.get(path);
        if (available == null) {
            URL url = null;
            try {
                url = servletContext.getResource(path);
            }
            catch (Exception exception) {}
            available = url == null ? Boolean.FALSE : Boolean.TRUE;
            _availabilities.put(path, available);
        }
        return available;
    }

    public static void reset() {
        _availabilities.clear();
    }
}

