/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public abstract class BaseUpgradePortletPreferences
extends UpgradeProcess {
    private static final String _GET_GROUP = "select * from Group_ where groupId = ?";
    private static final String _GET_LAYOUT = "select * from Layout where plid = ?";
    private static final String _GET_LAYOUT_UUID = "select uuid_ from Layout where groupId = ? and privateLayout = ? and layoutId = ?";
    private static final String _GET_USER = "select * from User_ where userId = ?";

    protected void deletePortletPreferences(long portletPreferencesId) throws Exception {
        this.runSQL("delete from PortletPreferences where portletPreferencesId = " + portletPreferencesId);
    }

    protected void doUpgrade() throws Exception {
        this.updatePortletPreferences();
    }

    protected long getCompanyId(long userId) throws Exception {
        long companyId = 0L;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_GET_USER);
            ps.setLong(1, userId);
            rs = ps.executeQuery();
            while (rs.next()) {
                companyId = rs.getLong("companyId");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp(con, ps, rs);
        return companyId;
    }

    protected Object[] getGroup(long groupId) throws Exception {
        Object[] group = null;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_GET_GROUP);
            ps.setLong(1, groupId);
            rs = ps.executeQuery();
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                group = new Object[]{groupId, companyId};
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp(con, ps, rs);
        return group;
    }

    protected Object[] getLayout(long plid) throws Exception {
        Object[] layout = null;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_GET_LAYOUT);
            ps.setLong(1, plid);
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                boolean privateLayout = rs.getBoolean("privateLayout");
                long layoutId = rs.getLong("layoutId");
                layout = new Object[]{groupId, companyId, privateLayout, layoutId};
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp(con, ps, rs);
        return layout;
    }

    protected String getLayoutUuid(long plid, long layoutId) throws Exception {
        Object[] layout = this.getLayout(plid);
        if (layout == null) {
            return null;
        }
        String uuid = null;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_GET_LAYOUT_UUID);
            long groupId = (Long)layout[0];
            boolean privateLayout = (Boolean)layout[2];
            ps.setLong(1, groupId);
            ps.setBoolean(2, privateLayout);
            ps.setLong(3, layoutId);
            rs = ps.executeQuery();
            if (rs.next()) {
                uuid = rs.getString("uuid_");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp(con, ps, rs);
        return uuid;
    }

    protected String[] getPortletIds() {
        return new String[0];
    }

    protected String getUpdatePortletPreferencesWhereClause() {
        String[] portletIds = this.getPortletIds();
        if (portletIds.length == 0) {
            throw new IllegalArgumentException("Subclasses must override getPortletIds or getUpdatePortletPreferencesWhereClause");
        }
        StringBundler sb = new StringBundler(portletIds.length * 5 - 1);
        int i = 0;
        while (i < portletIds.length) {
            String portletId = portletIds[i];
            sb.append("portletId ");
            if (portletId.contains("%")) {
                sb.append(" like '");
                sb.append(portletId);
                sb.append("'");
            } else {
                sb.append(" = '");
                sb.append(portletId);
                sb.append("'");
            }
            if (i + 1 < portletIds.length) {
                sb.append(" or ");
            }
            ++i;
        }
        return sb.toString();
    }

    protected void updatePortletPreferences() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            StringBundler sb = new StringBundler(4);
            sb.append("select portletPreferencesId, ownerId, ownerType, ");
            sb.append("plid, portletId, preferences from PortletPreferences");
            String whereClause = this.getUpdatePortletPreferencesWhereClause();
            if (Validator.isNotNull(whereClause)) {
                sb.append(" where ");
                sb.append(whereClause);
            }
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                long portletPreferencesId = rs.getLong("portletPreferencesId");
                long ownerId = rs.getLong("ownerId");
                int ownerType = rs.getInt("ownerType");
                long plid = rs.getLong("plid");
                String portletId = rs.getString("portletId");
                String preferences = rs.getString("preferences");
                long companyId = 0L;
                if (ownerType == 1) {
                    companyId = ownerId;
                } else if (ownerType == 2) {
                    Object[] group = this.getGroup(ownerId);
                    if (group != null) {
                        companyId = (Long)group[1];
                    }
                } else if (ownerType == 3) {
                    Object[] layout = this.getLayout(plid);
                    if (layout != null) {
                        companyId = (Long)layout[1];
                    }
                } else if (ownerType == 4) {
                    companyId = this.getCompanyId(ownerId);
                }
                if (companyId > 0L) {
                    String newPreferences = this.upgradePreferences(companyId, ownerId, ownerType, plid, portletId, preferences);
                    this.updatePortletPreferences(portletPreferencesId, newPreferences);
                    continue;
                }
                this.deletePortletPreferences(portletPreferencesId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp(con, ps, rs);
    }

    protected void updatePortletPreferences(long portletPreferencesId, String preferences) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("update PortletPreferences set preferences = ? where portletPreferencesId = " + portletPreferencesId);
            ps.setString(1, preferences);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(con, ps);
            throw throwable;
        }
        DataAccess.cleanUp(con, ps);
    }

    protected abstract String upgradePreferences(long var1, long var3, int var5, long var6, String var8, String var9) throws Exception;
}

