/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateClassLoader
extends ClassLoader {
    private static Log _log;
    private static Method _findClassMethod;
    private static Method _getResourceMethod;
    private static Method _getResourcesMethod;
    private static Method _loadClassMethod;
    private List<WeakReference<ClassLoader>> _classLoaderReferences = new ArrayList<WeakReference<ClassLoader>>();
    private WeakReference<ClassLoader> _parentClassLoaderReference;

    static {
        block2: {
            _log = LogFactoryUtil.getLog(AggregateClassLoader.class);
            try {
                _findClassMethod = ReflectionUtil.getDeclaredMethod(ClassLoader.class, "findClass", String.class);
                _getResourceMethod = ReflectionUtil.getDeclaredMethod(ClassLoader.class, "getResource", String.class);
                _getResourcesMethod = ReflectionUtil.getDeclaredMethod(ClassLoader.class, "getResources", String.class);
                _loadClassMethod = ReflectionUtil.getDeclaredMethod(ClassLoader.class, "loadClass", String.class, Boolean.TYPE);
            }
            catch (Exception e) {
                if (!_log.isErrorEnabled()) break block2;
                _log.error("Unable to locate required methods", e);
            }
        }
    }

    public static ClassLoader getAggregateClassLoader(ClassLoader parentClassLoader, ClassLoader[] classLoaders) {
        if (classLoaders == null || classLoaders.length == 0) {
            return null;
        }
        if (classLoaders.length == 1) {
            return classLoaders[0];
        }
        AggregateClassLoader aggregateClassLoader = new AggregateClassLoader(parentClassLoader);
        ClassLoader[] classLoaderArray = classLoaders;
        int n = classLoaders.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader classLoader = classLoaderArray[n2];
            aggregateClassLoader.addClassLoader(classLoader);
            ++n2;
        }
        return aggregateClassLoader;
    }

    public static ClassLoader getAggregateClassLoader(ClassLoader[] classLoaders) {
        if (classLoaders == null || classLoaders.length == 0) {
            return null;
        }
        return AggregateClassLoader.getAggregateClassLoader(classLoaders[0], classLoaders);
    }

    public AggregateClassLoader(ClassLoader classLoader) {
        this._parentClassLoaderReference = new WeakReference<ClassLoader>(classLoader);
    }

    public void addClassLoader(ClassLoader classLoader) {
        if (this.getClassLoaders().contains(classLoader)) {
            return;
        }
        if (classLoader instanceof AggregateClassLoader && classLoader.getParent().equals(this.getParent())) {
            AggregateClassLoader aggregateClassLoader = (AggregateClassLoader)classLoader;
            for (ClassLoader curClassLoader : aggregateClassLoader.getClassLoaders()) {
                this.addClassLoader(curClassLoader);
            }
        } else {
            this._classLoaderReferences.add(new WeakReference<ClassLoader>(classLoader));
        }
    }

    public void addClassLoader(ClassLoader ... classLoaders) {
        ClassLoader[] classLoaderArray = classLoaders;
        int n = classLoaders.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader classLoader = classLoaderArray[n2];
            this.addClassLoader(classLoader);
            ++n2;
        }
    }

    public void addClassLoader(Collection<ClassLoader> classLoaders) {
        for (ClassLoader classLoader : classLoaders) {
            this.addClassLoader(classLoader);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AggregateClassLoader)) {
            return false;
        }
        AggregateClassLoader aggregateClassLoader = (AggregateClassLoader)obj;
        return this._classLoaderReferences.equals(aggregateClassLoader._classLoaderReferences) && (this.getParent() == null && aggregateClassLoader.getParent() == null || this.getParent() != null && this.getParent().equals(aggregateClassLoader.getParent()));
    }

    public List<ClassLoader> getClassLoaders() {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(this._classLoaderReferences.size());
        Iterator<WeakReference<ClassLoader>> itr = this._classLoaderReferences.iterator();
        while (itr.hasNext()) {
            WeakReference<ClassLoader> weakReference = itr.next();
            ClassLoader classLoader = (ClassLoader)weakReference.get();
            if (classLoader == null) {
                itr.remove();
                continue;
            }
            classLoaders.add(classLoader);
        }
        return classLoaders;
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            URL url = AggregateClassLoader._getResource(classLoader, name);
            if (url == null) continue;
            return url;
        }
        ClassLoader parentClassLoader = (ClassLoader)this._parentClassLoaderReference.get();
        if (parentClassLoader == null) {
            return null;
        }
        return parentClassLoader.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ClassLoader classLoader : this.getClassLoaders()) {
            urls.addAll(Collections.list(AggregateClassLoader._getResources(classLoader, name)));
        }
        ClassLoader parentClassLoader = (ClassLoader)this._parentClassLoaderReference.get();
        if (parentClassLoader != null) {
            urls.addAll(Collections.list(AggregateClassLoader._getResources(parentClassLoader, name)));
        }
        return Collections.enumeration(urls);
    }

    public int hashCode() {
        if (this._classLoaderReferences != null) {
            return this._classLoaderReferences.hashCode();
        }
        return 0;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            try {
                return AggregateClassLoader._findClass(classLoader, name);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        throw new ClassNotFoundException("Unable to find class " + name);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loadedClass = null;
        for (ClassLoader classLoader : this.getClassLoaders()) {
            try {
                loadedClass = AggregateClassLoader._loadClass(classLoader, name, resolve);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (loadedClass == null) {
            ClassLoader parentClassLoader = (ClassLoader)this._parentClassLoaderReference.get();
            if (parentClassLoader == null) {
                throw new ClassNotFoundException("Parent class loader has been garbage collected");
            }
            loadedClass = AggregateClassLoader._loadClass(parentClassLoader, name, resolve);
        } else if (resolve) {
            this.resolveClass(loadedClass);
        }
        return loadedClass;
    }

    private static Class<?> _findClass(ClassLoader classLoader, String name) throws ClassNotFoundException {
        try {
            return (Class)_findClassMethod.invoke((Object)classLoader, name);
        }
        catch (InvocationTargetException ite) {
            throw new ClassNotFoundException("Unable to find class " + name, ite.getTargetException());
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Unable to find class " + name, e);
        }
    }

    private static URL _getResource(ClassLoader classLoader, String name) {
        try {
            return (URL)_getResourceMethod.invoke((Object)classLoader, name);
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Enumeration<URL> _getResources(ClassLoader classLoader, String name) throws IOException {
        try {
            return (Enumeration)_getResourcesMethod.invoke((Object)classLoader, name);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            throw new IOException(t.getMessage());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private static Class<?> _loadClass(ClassLoader classLoader, String name, boolean resolve) throws ClassNotFoundException {
        try {
            return (Class)_loadClassMethod.invoke((Object)classLoader, name, resolve);
        }
        catch (InvocationTargetException ite) {
            throw new ClassNotFoundException("Unable to load class " + name, ite.getTargetException());
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Unable to load class " + name, e);
        }
    }
}

