/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtil {
    private static final Pattern _ANNOTATION_NAME_REGEXP = Pattern.compile("@(\\w+)$");
    private static final Pattern _ANNOTATION_PARAMETERS_REGEXP = Pattern.compile("@(\\w+)\\({0,1}\\{{0,1}([^)}]+)\\}{0,1}\\){0,1}");
    private static final String _CLASS_EXTENSION = ".class";
    private static Log _log = LogFactoryUtil.getLog(ClassUtil.class);

    public static Set<String> getClasses(File file) throws IOException {
        String fileName = file.getName();
        if (fileName.endsWith(".java")) {
            fileName = fileName.substring(0, fileName.length() - 5);
        }
        return ClassUtil.getClasses(new UnsyncBufferedReader(new FileReader(file)), fileName);
    }

    public static Set<String> getClasses(Reader reader, String className) throws IOException {
        HashSet<String> classes = new HashSet<String>();
        StreamTokenizer st = new StreamTokenizer(reader);
        ClassUtil._setupParseTableForAnnotationProcessing(st);
        while (st.nextToken() != -1) {
            if (st.ttype != -3) continue;
            if (st.sval.equals("class") || st.sval.equals("enum") || st.sval.equals("interface") || st.sval.equals("@interface")) break;
            if (!st.sval.startsWith("@")) continue;
            st.ordinaryChar(32);
            st.wordChars(61, 61);
            String[] las = ClassUtil._processAnnotation(st.sval, st);
            int i = 0;
            while (i < las.length) {
                classes.add(las[i]);
                ++i;
            }
            ClassUtil._setupParseTableForAnnotationProcessing(st);
        }
        ClassUtil._setupParseTable(st);
        while (st.nextToken() != -1) {
            if (st.ttype == -3) {
                if (st.sval.indexOf(46) >= 0) {
                    classes.add(st.sval.substring(0, st.sval.indexOf(46)));
                    continue;
                }
                classes.add(st.sval);
                continue;
            }
            if (st.ttype == -2 || st.ttype == 10 || !Character.isUpperCase((char)st.ttype)) continue;
            classes.add(String.valueOf((char)st.ttype));
        }
        classes.remove(className);
        return classes;
    }

    public static String getParentPath(ClassLoader classLoader, String className) {
        int pos;
        String parentPath;
        if (_log.isDebugEnabled()) {
            _log.debug("Class name " + className);
        }
        if (!className.endsWith(_CLASS_EXTENSION)) {
            className = String.valueOf(className) + _CLASS_EXTENSION;
        }
        className = StringUtil.replace(className, '.', '/');
        className = StringUtil.replace(className, "/class", _CLASS_EXTENSION);
        URL url = classLoader.getResource(className);
        String path = null;
        try {
            path = url.getPath();
            URI uri = new URI(path);
            String scheme = uri.getScheme();
            if (path.contains("!") && (scheme == null || scheme.length() <= 1)) {
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
            } else {
                path = uri.getPath();
                if (path == null) {
                    path = url.getFile();
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            path = url.getFile();
        }
        if (ServerDetector.isJBoss() && path.startsWith("file:") && !path.startsWith("file:/")) {
            path = path.substring(5, path.length());
            path = "file:/".concat(path);
            path = StringUtil.replace(path, "%5C", "/");
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Path " + path);
        }
        if ((parentPath = path.substring(0, pos = path.indexOf(className))).startsWith("jar:")) {
            parentPath = parentPath.substring(4, parentPath.length());
        }
        if (parentPath.startsWith("file:/")) {
            parentPath = parentPath.substring(6, parentPath.length());
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Parent path " + parentPath);
        }
        return parentPath;
    }

    public static boolean isSubclass(Class<?> a, Class<?> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Class<?> x = a;
        while (x != null) {
            if (x == b) {
                return true;
            }
            if (b.isInterface()) {
                Class<?>[] interfaces = x.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    if (ClassUtil.isSubclass(interfaces[i], b)) {
                        return true;
                    }
                    ++i;
                }
            }
            x = x.getSuperclass();
        }
        return false;
    }

    public static boolean isSubclass(Class<?> a, String s) {
        if (a == null || s == null) {
            return false;
        }
        if (a.getName().equals(s)) {
            return true;
        }
        Class<?> x = a;
        while (x != null) {
            if (x.getName().equals(s)) {
                return true;
            }
            Class<?>[] interfaces = x.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (ClassUtil.isSubclass(interfaces[i], s)) {
                    return true;
                }
                ++i;
            }
            x = x.getSuperclass();
        }
        return false;
    }

    private static String[] _processAnnotation(String s, StreamTokenizer st) throws IOException {
        s = s.trim();
        List<String> tokens = new ArrayList<String>();
        Matcher annotationNameMatcher = _ANNOTATION_NAME_REGEXP.matcher(s);
        Matcher annotationParametersMatcher = _ANNOTATION_PARAMETERS_REGEXP.matcher(s);
        if (annotationNameMatcher.matches()) {
            String annotationName = annotationNameMatcher.group();
            tokens.add(annotationName.replace("@", ""));
        } else if (annotationParametersMatcher.matches()) {
            if (!s.trim().endsWith(")")) {
                while (st.nextToken() != -1) {
                    if (st.ttype == -3 && (s = String.valueOf(s) + st.sval).trim().endsWith(")")) break;
                }
            }
            if ((annotationParametersMatcher = _ANNOTATION_PARAMETERS_REGEXP.matcher(s)).matches()) {
                String annotationName = annotationParametersMatcher.group(1);
                String annotationParameters = annotationParametersMatcher.group(2);
                tokens.add(annotationName.replace("@", ""));
                tokens = ClassUtil._processAnnotationParameters(annotationParameters, tokens);
            }
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private static List<String> _processAnnotationParameters(String s, List<String> tokens) throws IOException {
        StreamTokenizer st = new StreamTokenizer(new UnsyncStringReader(s));
        ClassUtil._setupParseTable(st);
        while (st.nextToken() != -1) {
            if (st.ttype == -3) {
                if (st.sval.indexOf(46) >= 0) {
                    tokens.add(st.sval.substring(0, st.sval.indexOf(46)));
                    continue;
                }
                tokens.add(st.sval);
                continue;
            }
            if (st.ttype == -2 || st.ttype == 10 || !Character.isUpperCase((char)st.ttype)) continue;
            tokens.add(String.valueOf((char)st.ttype));
        }
        return tokens;
    }

    private static void _setupParseTable(StreamTokenizer st) {
        st.resetSyntax();
        st.slashSlashComments(true);
        st.slashStarComments(true);
        st.wordChars(97, 122);
        st.wordChars(65, 90);
        st.wordChars(46, 46);
        st.wordChars(48, 57);
        st.wordChars(95, 95);
        st.lowerCaseMode(false);
        st.eolIsSignificant(false);
        st.quoteChar(34);
        st.quoteChar(39);
        st.parseNumbers();
    }

    private static void _setupParseTableForAnnotationProcessing(StreamTokenizer st) {
        ClassUtil._setupParseTable(st);
        st.wordChars(64, 64);
        st.wordChars(40, 40);
        st.wordChars(41, 41);
        st.wordChars(123, 123);
        st.wordChars(125, 125);
        st.wordChars(44, 44);
    }
}

