/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleUtil {
    private static final int _MAX_LOCALES = 1000;
    private static LocaleUtil _instance = new LocaleUtil();
    private static Log _log = LogFactoryUtil.getLog(LocaleUtil.class);
    private Locale _locale;
    private Map<String, Locale> _locales = new HashMap<String, Locale>();

    public static Locale fromLanguageId(String languageId) {
        return _instance._fromLanguageId(languageId);
    }

    public static Locale[] fromLanguageIds(String[] languageIds) {
        return _instance._fromLanguageIds(languageIds);
    }

    public static Locale getDefault() {
        return _instance._getDefault();
    }

    public static LocaleUtil getInstance() {
        return _instance;
    }

    public static Map<String, String> getISOLanguages(Locale locale) {
        return _instance._getISOLanguages(locale);
    }

    public static void setDefault(String userLanguage, String userCountry, String userVariant) {
        _instance._setDefault(userLanguage, userCountry, userVariant);
    }

    public static String toLanguageId(Locale locale) {
        return _instance._toLanguageId(locale);
    }

    public static String[] toLanguageIds(Locale[] locales) {
        return _instance._toLanguageIds(locales);
    }

    public static String toW3cLanguageId(Locale locale) {
        return _instance._toW3cLanguageId(locale);
    }

    public static String toW3cLanguageId(String languageId) {
        return _instance._toW3cLanguageId(languageId);
    }

    public static String[] toW3cLanguageIds(Locale[] locales) {
        return _instance._toW3cLanguageIds(locales);
    }

    public static String[] toW3cLanguageIds(String[] languageIds) {
        return _instance._toW3cLanguageIds(languageIds);
    }

    private LocaleUtil() {
        this._locale = new Locale("en", "US");
    }

    private Locale _fromLanguageId(String languageId) {
        Locale locale;
        block11: {
            if (languageId == null) {
                return this._locale;
            }
            locale = this._locales.get(languageId);
            if (locale != null) {
                return locale;
            }
            try {
                int pos = languageId.indexOf(95);
                if (pos == -1) {
                    locale = new Locale(languageId);
                } else {
                    String[] languageIdParts = StringUtil.split(languageId, '_');
                    String languageCode = languageIdParts[0];
                    String countryCode = languageIdParts[1];
                    String variant = null;
                    if (languageIdParts.length > 2) {
                        variant = languageIdParts[2];
                    }
                    locale = Validator.isNotNull(variant) ? new Locale(languageCode, countryCode, variant) : new Locale(languageCode, countryCode);
                }
                if (this._locales.size() < 1000) {
                    this._locales.put(languageId, locale);
                } else if (_log.isWarnEnabled()) {
                    _log.warn("There are too many entries in the locales map");
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block11;
                _log.warn(String.valueOf(languageId) + " is not a valid language id");
            }
        }
        if (locale == null) {
            locale = this._locale;
        }
        return locale;
    }

    private Locale[] _fromLanguageIds(String[] languageIds) {
        Locale[] locales = new Locale[languageIds.length];
        int i = 0;
        while (i < languageIds.length) {
            locales[i] = this._fromLanguageId(languageIds[i]);
            ++i;
        }
        return locales;
    }

    private Locale _getDefault() {
        Locale locale = LocaleThreadLocal.getDefaultLocale();
        if (locale != null) {
            return locale;
        }
        return this._locale;
    }

    private Map<String, String> _getISOLanguages(Locale locale) {
        TreeMap<String, String> isoLanguages = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        String[] stringArray = Locale.getISOLanguages();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String isoLanguageId = stringArray[n2];
            Locale isoLocale = this._fromLanguageId(isoLanguageId);
            isoLanguages.put(isoLocale.getDisplayLanguage(locale), isoLanguageId);
            ++n2;
        }
        return isoLanguages;
    }

    private void _setDefault(String userLanguage, String userCountry, String userVariant) {
        if (Validator.isNotNull(userLanguage) && Validator.isNull(userCountry) && Validator.isNull(userVariant)) {
            this._locale = new Locale(userLanguage);
        } else if (Validator.isNotNull(userLanguage) && Validator.isNotNull(userCountry) && Validator.isNull(userVariant)) {
            this._locale = new Locale(userLanguage, userCountry);
        } else if (Validator.isNotNull(userLanguage) && Validator.isNotNull(userCountry) && Validator.isNotNull(userVariant)) {
            this._locale = new Locale(userLanguage, userCountry, userVariant);
        }
    }

    private String _toLanguageId(Locale locale) {
        if (locale == null) {
            locale = this._locale;
        }
        String country = locale.getCountry();
        boolean hasCountry = false;
        if (country.length() != 0) {
            hasCountry = true;
        }
        String variant = locale.getVariant();
        boolean hasVariant = false;
        if (variant.length() != 0) {
            hasVariant = true;
        }
        if (!hasCountry && !hasVariant) {
            return locale.getLanguage();
        }
        int length = 3;
        if (hasCountry && hasVariant) {
            length = 5;
        }
        StringBundler sb = new StringBundler(length);
        sb.append(locale.getLanguage());
        if (hasCountry) {
            sb.append("_");
            sb.append(country);
        }
        if (hasVariant) {
            sb.append("_");
            sb.append(variant);
        }
        return sb.toString();
    }

    private String[] _toLanguageIds(Locale[] locales) {
        String[] languageIds = new String[locales.length];
        int i = 0;
        while (i < locales.length) {
            languageIds[i] = this._toLanguageId(locales[i]);
            ++i;
        }
        return languageIds;
    }

    private String _toW3cLanguageId(Locale locale) {
        return this._toW3cLanguageId(this._toLanguageId(locale));
    }

    private String _toW3cLanguageId(String languageId) {
        return StringUtil.replace(languageId, '_', '-');
    }

    private String[] _toW3cLanguageIds(Locale[] locales) {
        return this._toW3cLanguageIds(this._toLanguageIds(locales));
    }

    private String[] _toW3cLanguageIds(String[] languageIds) {
        String[] w3cLanguageIds = new String[languageIds.length];
        int i = 0;
        while (i < languageIds.length) {
            w3cLanguageIds[i] = this._toW3cLanguageId(languageIds[i]);
            ++i;
        }
        return w3cLanguageIds;
    }
}

