/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.MethodKey;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCache {
    private static MethodCache _instance = new MethodCache();
    private Map<String, Class<?>> _classesMap = new HashMap();
    private Map<MethodKey, Method> _methodsMap = new HashMap<MethodKey, Method>();

    public static Method get(String className, String methodName) throws ClassNotFoundException, NoSuchMethodException {
        return MethodCache.get(null, null, className, methodName);
    }

    public static Method get(String className, String methodName, Class<?>[] parameterTypes) throws ClassNotFoundException, NoSuchMethodException {
        return MethodCache.get(null, null, className, methodName, parameterTypes);
    }

    public static Method get(Map<String, Class<?>> classesMap, Map<MethodKey, Method> methodsMap, String className, String methodName) throws ClassNotFoundException, NoSuchMethodException {
        return MethodCache.get(className, methodName, new Class[0]);
    }

    public static Method get(Map<String, Class<?>> classesMap, Map<MethodKey, Method> methodsMap, String className, String methodName, Class<?>[] parameterTypes) throws ClassNotFoundException, NoSuchMethodException {
        MethodKey methodKey = new MethodKey(className, methodName, parameterTypes);
        return _instance._get(classesMap, methodsMap, methodKey);
    }

    public static Method get(MethodKey methodKey) throws ClassNotFoundException, NoSuchMethodException {
        return _instance._get(null, null, methodKey);
    }

    public static Method put(MethodKey methodKey, Method method) {
        return _instance._put(methodKey, method);
    }

    public static void remove(Class<?> clazz) {
        _instance._remove(clazz);
    }

    public static void reset() {
        _instance._reset();
    }

    private MethodCache() {
    }

    private Method _get(Map<String, Class<?>> classesMap, Map<MethodKey, Method> methodsMap, MethodKey methodKey) throws ClassNotFoundException, NoSuchMethodException {
        Method method;
        if (classesMap == null) {
            classesMap = this._classesMap;
        }
        if (methodsMap == null) {
            methodsMap = this._methodsMap;
        }
        if ((method = methodsMap.get(methodKey)) == null) {
            String className = methodKey.getClassName();
            String methodName = methodKey.getMethodName();
            Class<?>[] parameterTypes = methodKey.getParameterTypes();
            Class<?> clazz = classesMap.get(className);
            if (clazz == null) {
                Thread currentThread = Thread.currentThread();
                ClassLoader contextClassLoader = currentThread.getContextClassLoader();
                clazz = contextClassLoader.loadClass(className);
                classesMap.put(className, clazz);
            }
            method = clazz.getMethod(methodName, parameterTypes);
            methodsMap.put(methodKey, method);
        }
        return method;
    }

    private Method _put(MethodKey methodKey, Method method) {
        return this._methodsMap.put(methodKey, method);
    }

    private void _remove(Class<?> clazz) {
        this._classesMap.remove(clazz.getName());
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            this._methodsMap.remove(new MethodKey(method));
            ++n2;
        }
    }

    private void _reset() {
        this._classesMap.clear();
        this._methodsMap.clear();
    }
}

