/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.MethodCache;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodHandler
implements Serializable {
    private Object[] _arguments;
    private MethodKey _methodKey;

    public MethodHandler(Method method, Object ... arguments) {
        this(new MethodKey(method), arguments);
    }

    public MethodHandler(MethodKey methodKey, Object ... arguments) {
        this._methodKey = methodKey;
        this._arguments = arguments;
    }

    public Object[] getArguments() {
        Object[] arguments = new Object[this._arguments.length];
        System.arraycopy(this._arguments, 0, arguments, 0, this._arguments.length);
        return arguments;
    }

    public Class<?>[] getArgumentsClasses() {
        return this._methodKey.getParameterTypes();
    }

    public String getClassName() {
        return this._methodKey.getClassName();
    }

    public MethodKey getMethodKey() {
        return this._methodKey;
    }

    public String getMethodName() {
        return this._methodKey.getMethodName();
    }

    public Object invoke(boolean newInstance) throws Exception {
        Method method = MethodCache.get(this._methodKey);
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        Object targetObject = null;
        if (newInstance && !Modifier.isStatic(method.getModifiers())) {
            Class<?> targetClass = contextClassLoader.loadClass(this.getClassName());
            targetObject = targetClass.newInstance();
        }
        return method.invoke(targetObject, this._arguments);
    }

    public Object invoke(Object target) throws Exception {
        Method method = MethodCache.get(this._methodKey);
        return method.invoke(target, this._arguments);
    }

    public String toString() {
        StringBundler sb = new StringBundler(5);
        sb.append("{arguments=");
        sb.append(Arrays.toString(this._arguments));
        sb.append(", methodKey=");
        sb.append(this._methodKey);
        sb.append("}");
        return sb.toString();
    }
}

