/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private ClassLoader _contextClassLoader;
    private AtomicInteger _counter = new AtomicInteger();
    private ThreadGroup _group;
    private String _name;
    private int _priority;

    public NamedThreadFactory(String name, int priority, ClassLoader contextClassLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            this._group = securityManager.getThreadGroup();
        } else {
            Thread currentThread = Thread.currentThread();
            this._group = currentThread.getThreadGroup();
        }
        this._name = name;
        this._priority = priority;
        this._contextClassLoader = contextClassLoader;
    }

    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this._group, runnable, this._name.concat("-").concat(String.valueOf(this._counter.incrementAndGet())));
        thread.setDaemon(true);
        thread.setPriority(this._priority);
        if (this._contextClassLoader != null) {
            thread.setContextClassLoader(this._contextClassLoader);
        }
        return thread;
    }
}

