/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.PortalInitableUtil;
import com.liferay.portal.kernel.util.PortalLifecycle;
import java.util.ArrayList;
import java.util.List;

public class PortalLifecycleUtil {
    private static boolean _inFlushDestroys;
    private static List<PortalLifecycle> _portalLifecyclesDestroy;
    private static List<PortalLifecycle> _portalLifecyclesInit;

    static {
        _portalLifecyclesDestroy = new ArrayList<PortalLifecycle>();
        _portalLifecyclesInit = new ArrayList<PortalLifecycle>();
    }

    public static void flushDestroys() {
        _inFlushDestroys = true;
        for (PortalLifecycle portalLifecycle : _portalLifecyclesDestroy) {
            portalLifecycle.portalDestroy();
        }
        _portalLifecyclesDestroy.clear();
        _inFlushDestroys = false;
    }

    public static void flushInits() {
        if (_portalLifecyclesInit != null) {
            List<PortalLifecycle> portalLifecyclesInit = _portalLifecyclesInit;
            _portalLifecyclesInit = null;
            for (PortalLifecycle portalLifecycle : portalLifecyclesInit) {
                portalLifecycle.portalInit();
            }
        }
        PortalInitableUtil.flushInitables();
    }

    public static void register(PortalLifecycle portalLifecycle) {
        PortalLifecycleUtil.register(portalLifecycle, 0);
    }

    public static void register(PortalLifecycle portalLifecycle, int method) {
        if (method == 0 || method == 2) {
            if (_portalLifecyclesInit == null) {
                portalLifecycle.portalInit();
            } else {
                _portalLifecyclesInit.add(portalLifecycle);
            }
        }
        if (method == 0 || method == 1) {
            _portalLifecyclesDestroy.add(portalLifecycle);
        }
    }

    public static void removeDestroy(PortalLifecycle portalLifecycle) {
        if (!_inFlushDestroys) {
            _portalLifecyclesDestroy.remove(portalLifecycle);
        }
    }
}

