/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedArrayList<E>
extends ArrayList<E> {
    private Comparator<E> _comparator;

    public SortedArrayList() {
    }

    public SortedArrayList(Collection<? extends E> c) {
        this.addAll(c);
    }

    public SortedArrayList(Comparator<E> comparator) {
        this._comparator = comparator;
    }

    @Override
    public boolean add(E e) {
        int index = 0;
        if (!this.isEmpty()) {
            index = this._findInsertionPoint(e);
        }
        super.add(index, e);
        return true;
    }

    @Override
    public void add(int index, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        Iterator<E> itr = c.iterator();
        while (itr.hasNext()) {
            if (!this.add(itr.next()) || modified) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E e) {
        throw new UnsupportedOperationException();
    }

    protected int compare(E e1, E e2) {
        if (this._comparator == null) {
            Comparable comparator1 = (Comparable)e1;
            return comparator1.compareTo(e2);
        }
        return this._comparator.compare(e1, e2);
    }

    private int _findInsertionPoint(E e) {
        return this._findInsertionPoint(e, 0, this.size() - 1);
    }

    private int _findInsertionPoint(E e, int low, int high) {
        while (low <= high) {
            int mid = low + high >>> 1;
            int delta = this.compare(this.get(mid), e);
            if (delta > 0) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return low;
    }
}

