/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;

public class StreamUtil {
    public static final int BUFFER_SIZE = GetterUtil.getInteger(System.getProperty(String.valueOf(StreamUtil.class.getName()) + ".buffer.size"), 8192);
    public static final boolean FORCE_TIO = GetterUtil.getBoolean(System.getProperty(String.valueOf(StreamUtil.class.getName()) + ".force.tio"));
    private static Log _log = LogFactoryUtil.getLog(StreamUtil.class);

    public static void cleanUp(Channel channel) {
        block3: {
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(e, e);
            }
        }
    }

    public static void cleanUp(Channel inputChannel, Channel outputChannel) {
        StreamUtil.cleanUp(inputChannel);
        StreamUtil.cleanUp(outputChannel);
    }

    public static void cleanUp(InputStream inputStream) {
        block3: {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(e, e);
            }
        }
    }

    public static void cleanUp(InputStream inputStream, OutputStream outputStream) {
        StreamUtil.cleanUp(outputStream);
        StreamUtil.cleanUp(inputStream);
    }

    public static void cleanUp(OutputStream outputStream) {
        block7: {
            block6: {
                try {
                    if (outputStream != null) {
                        outputStream.flush();
                    }
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block6;
                    _log.warn(e, e);
                }
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block7;
                _log.warn(e, e);
            }
        }
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        StreamUtil.transfer(inputStream, outputStream, BUFFER_SIZE, true);
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream, boolean cleanUp) throws IOException {
        StreamUtil.transfer(inputStream, outputStream, BUFFER_SIZE, cleanUp);
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        StreamUtil.transfer(inputStream, outputStream, bufferSize, true);
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream, int bufferSize, boolean cleanUp) throws IOException {
        StreamUtil.transfer(inputStream, outputStream, bufferSize, cleanUp, 0L);
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream, int bufferSize, boolean cleanUp, long length) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream cannot be null");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream cannot be null");
        }
        if (bufferSize <= 0) {
            bufferSize = BUFFER_SIZE;
        }
        try {
            if (!FORCE_TIO && inputStream instanceof FileInputStream && outputStream instanceof FileOutputStream) {
                FileInputStream fileInputStream = (FileInputStream)inputStream;
                FileOutputStream fileOutputStream = (FileOutputStream)outputStream;
                StreamUtil.transferFileChannel(fileInputStream.getChannel(), fileOutputStream.getChannel(), length);
            } else {
                StreamUtil.transferByteArray(inputStream, outputStream, bufferSize, length);
            }
        }
        finally {
            if (cleanUp) {
                StreamUtil.cleanUp(inputStream, outputStream);
            }
        }
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream, long length) throws IOException {
        StreamUtil.transfer(inputStream, outputStream, BUFFER_SIZE, true, length);
    }

    protected static void transferByteArray(InputStream inputStream, OutputStream outputStream, int bufferSize, long length) throws IOException {
        byte[] bytes = new byte[bufferSize];
        long remainingLength = length;
        if (remainingLength > 0L) {
            while (remainingLength > 0L) {
                int readBytes = inputStream.read(bytes, 0, (int)Math.min(remainingLength, (long)bufferSize));
                if (readBytes != -1) {
                    outputStream.write(bytes, 0, readBytes);
                    remainingLength -= (long)readBytes;
                    continue;
                }
                break;
            }
        } else {
            int value = -1;
            while ((value = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, value);
            }
        }
    }

    protected static void transferFileChannel(FileChannel inputFileChannel, FileChannel outputFileChannel, long length) throws IOException {
        long size = 0L;
        size = length > 0L ? length : inputFileChannel.size();
        long position = 0L;
        while (position < size) {
            position += inputFileChannel.transferTo(position, size - position, outputFileChannel);
        }
    }
}

