/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.ByteArrayFileInputStream;
import com.liferay.portal.kernel.io.FileFilter;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class TempFileUtil {
    private static final String _BASE_TEMP_PATHNAME = "/liferay/";
    private static final String _SUFFIX_TEMP_FILENAME = "_temp.tmp";
    private static final String _SUFFIX_TEMP_FILENAME_REGEX = ".*_temp\\.tmp";
    private static final String _SUFFIX_TEMP_FILENAME_USERID_REGEX = "_temp\\.tmp";

    public static String addTempFile(long userId, String tempPathName, File file) throws IOException, PortalException, SystemException {
        String tempFileName = FileUtil.createTempFileName();
        DLStoreUtil.validate(tempFileName, true, file);
        File tempFile = TempFileUtil.getTempFile(tempFileName, tempPathName);
        FileUtil.copyFile(file, tempFile);
        return tempFileName;
    }

    public static String addTempFile(long userId, String fileName, String tempPathName, File file) throws IOException, PortalException, SystemException {
        DLStoreUtil.validate(fileName, true, file);
        File tempFile = TempFileUtil.getTempFile(userId, fileName, tempPathName);
        FileUtil.copyFile(file, tempFile);
        return fileName;
    }

    public static String addTempFile(long userId, String fileName, String tempPathName, InputStream inputStream) throws IOException, PortalException, SystemException {
        File file = null;
        if (inputStream instanceof ByteArrayFileInputStream) {
            ByteArrayFileInputStream byteArrayFileInputStream = (ByteArrayFileInputStream)inputStream;
            file = byteArrayFileInputStream.getFile();
            DLStoreUtil.validate(fileName, true, file);
        } else {
            DLStoreUtil.validate(fileName, true, inputStream);
        }
        File tempFile = TempFileUtil.getTempFile(userId, fileName, tempPathName);
        if (file != null) {
            FileUtil.copyFile(file, tempFile);
        } else {
            FileUtil.write(tempFile, inputStream);
        }
        return fileName;
    }

    public static String addTempFile(String tempPathName, File file) throws IOException, PortalException, SystemException {
        String tempFileName = FileUtil.createTempFileName();
        DLStoreUtil.validate(tempFileName, false, file);
        File tempFile = TempFileUtil.getTempFile(tempFileName, tempPathName);
        FileUtil.copyFile(file, tempFile);
        return tempFileName;
    }

    public static String addTempFile(String fileName, String tempPathName, File file) throws IOException, PortalException, SystemException {
        DLStoreUtil.validate(fileName, true, file);
        File tempFile = TempFileUtil.getTempFile(fileName, tempPathName);
        FileUtil.copyFile(file, tempFile);
        return fileName;
    }

    public static void deleteTempFile(long userId, String fileName, String tempPathName) {
        File file = TempFileUtil.getTempFile(userId, fileName, tempPathName);
        FileUtil.delete(file);
    }

    public static void deleteTempFile(String fileName, String tempPathName) {
        File file = TempFileUtil.getTempFile(fileName, tempPathName);
        FileUtil.delete(file);
    }

    public static File getTempFile(long userId, String fileName, String tempPathName) {
        String absoluteFilePath = TempFileUtil.getTempAbsolutePath(userId, fileName, tempPathName);
        return new File(absoluteFilePath);
    }

    public static File getTempFile(String fileName, String tempPathName) {
        String absoluteFilePath = TempFileUtil.getTempAbsolutePath(fileName, tempPathName);
        return new File(absoluteFilePath);
    }

    public static String[] getTempFileEntryNames(long userId, String tempPathName) {
        File dir = new File(TempFileUtil.getTempAbsolutePath(tempPathName));
        StringBundler sb = new StringBundler(5);
        sb.append(".");
        sb.append("*");
        sb.append("_");
        sb.append(userId);
        sb.append(_SUFFIX_TEMP_FILENAME_USERID_REGEX);
        FileFilter fileFilter = new FileFilter(sb.toString());
        File[] files = dir.listFiles(fileFilter);
        int count = 0;
        if (files != null) {
            count = files.length;
        }
        String[] fileNames = new String[count];
        int i = 0;
        while (i < count) {
            String fileName;
            File file = files[i];
            fileNames[i] = fileName = StringUtil.replace(file.getName(), "_" + userId + _SUFFIX_TEMP_FILENAME, "");
            ++i;
        }
        return fileNames;
    }

    public static String[] getTempFileEntryNames(String tempPathName) {
        File dir = new File(TempFileUtil.getTempAbsolutePath(tempPathName));
        File[] files = dir.listFiles(new FileFilter(_SUFFIX_TEMP_FILENAME_REGEX));
        String[] fileNames = new String[files.length];
        int i = 0;
        while (i < files.length) {
            String fileName;
            File file = files[i];
            fileNames[i] = fileName = StringUtil.replace(file.getName(), _SUFFIX_TEMP_FILENAME, "");
            ++i;
        }
        return fileNames;
    }

    private static String getTempAbsolutePath(long userId, String fileName, String tempPathName) {
        StringBundler sb = new StringBundler(5);
        sb.append(SystemProperties.get("java.io.tmpdir"));
        sb.append(_BASE_TEMP_PATHNAME);
        sb.append(tempPathName);
        sb.append("/");
        sb.append(TempFileUtil.getTempFileName(userId, fileName));
        return sb.toString();
    }

    private static String getTempAbsolutePath(String tempPathName) {
        StringBundler sb = new StringBundler(4);
        sb.append(SystemProperties.get("java.io.tmpdir"));
        sb.append(_BASE_TEMP_PATHNAME);
        sb.append(tempPathName);
        sb.append("/");
        return sb.toString();
    }

    private static String getTempAbsolutePath(String fileName, String tempPathName) {
        StringBundler sb = new StringBundler(5);
        sb.append(SystemProperties.get("java.io.tmpdir"));
        sb.append(_BASE_TEMP_PATHNAME);
        sb.append(tempPathName);
        sb.append("/");
        sb.append(TempFileUtil.getTempFileName(fileName));
        return sb.toString();
    }

    private static String getTempFileName(long userId, String fileName) {
        StringBundler sb = new StringBundler(4);
        sb.append(fileName);
        sb.append("_");
        sb.append(userId);
        sb.append(_SUFFIX_TEMP_FILENAME);
        return sb.toString();
    }

    private static String getTempFileName(String fileName) {
        return String.valueOf(fileName) + _SUFFIX_TEMP_FILENAME;
    }
}

