/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletCategory
implements Serializable {
    private static final String _DELIMITER = "//";
    private Map<String, PortletCategory> _categories = new HashMap<String, PortletCategory>();
    private String _name;
    private PortletCategory _parentPortletCategory;
    private String _path;
    private Set<String> _portletIds;

    public PortletCategory() {
        this("root");
    }

    public PortletCategory(String name) {
        this(name, new HashSet<String>());
    }

    public PortletCategory(String name, Set<String> portletIds) {
        this._portletIds = portletIds;
        if (name.contains(_DELIMITER)) {
            int index = name.lastIndexOf(_DELIMITER);
            this._name = name.substring(index + _DELIMITER.length());
            String parentName = name.substring(0, index);
            PortletCategory parentPortletCategory = new PortletCategory(parentName);
            parentPortletCategory.addCategory(this);
        } else {
            this._name = name;
            this._parentPortletCategory = null;
            this._path = name;
        }
    }

    public void addCategory(PortletCategory portletCategory) {
        portletCategory.setParentCategory(this);
        String path = this._path.concat(_DELIMITER).concat(portletCategory.getName());
        portletCategory.setPath(path);
        this._categories.put(portletCategory.getName(), portletCategory);
    }

    public Collection<PortletCategory> getCategories() {
        return Collections.unmodifiableCollection(this._categories.values());
    }

    public PortletCategory getCategory(String name) {
        return this._categories.get(name);
    }

    public String getName() {
        return this._name;
    }

    public PortletCategory getParentCategory() {
        return this._parentPortletCategory;
    }

    public String getPath() {
        return this._path;
    }

    public Set<String> getPortletIds() {
        return this._portletIds;
    }

    public PortletCategory getRootCategory() {
        if (this._parentPortletCategory == null) {
            return this;
        }
        return this._parentPortletCategory.getRootCategory();
    }

    public boolean isHidden() {
        return this._name.equals("category.hidden");
    }

    public void merge(PortletCategory newPortletCategory) {
        this._merge(this, newPortletCategory);
    }

    public void separate(String portletId) {
        HashSet<String> portletIds = new HashSet<String>(1);
        portletIds.add(portletId);
        this.separate(portletIds);
    }

    public void separate(Set<String> portletIds) {
        for (PortletCategory category : this._categories.values()) {
            category.separate(portletIds);
        }
        Iterator<String> portletIdsItr = this._portletIds.iterator();
        while (portletIdsItr.hasNext()) {
            String portletId = portletIdsItr.next();
            if (!portletIds.contains(portletId)) continue;
            portletIdsItr.remove();
        }
    }

    public void setPortletIds(Set<String> portletIds) {
        this._portletIds = portletIds;
    }

    protected void setParentCategory(PortletCategory portletCategory) {
        this._parentPortletCategory = portletCategory;
    }

    protected void setPath(String path) {
        this._path = path;
    }

    private void _merge(PortletCategory portletCategory1, PortletCategory portletCategory2) {
        for (PortletCategory curCategory2 : portletCategory2.getCategories()) {
            PortletCategory curCategory1 = portletCategory1.getCategory(curCategory2.getName());
            if (curCategory1 != null) {
                this._merge(curCategory1, curCategory2);
                continue;
            }
            portletCategory1.addCategory(curCategory2);
        }
        Set<String> portletIds1 = portletCategory1.getPortletIds();
        Set<String> portletIds2 = portletCategory2.getPortletIds();
        portletIds1.addAll(portletIds2);
    }
}

