/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.proxy;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.repository.proxy.RepositoryModelProxyBean;
import com.liferay.portal.service.ServiceContext;
import java.io.File;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalRepositoryProxyBean
extends RepositoryModelProxyBean
implements LocalRepository {
    private LocalRepository _localRepository;

    public LocalRepositoryProxyBean(LocalRepository localRepository, ClassLoader classLoader) {
        super(classLoader);
        this._localRepository = localRepository;
    }

    @Override
    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        FileEntry fileEntry = this._localRepository.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
        return this.newFileEntryProxyBean(fileEntry);
    }

    @Override
    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        FileEntry fileEntry = this._localRepository.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, is, size, serviceContext);
        return this.newFileEntryProxyBean(fileEntry);
    }

    @Override
    public Folder addFolder(long userId, long parentFolderId, String title, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        Folder folder = this._localRepository.addFolder(userId, parentFolderId, title, description, serviceContext);
        return this.newFolderProxyBean(folder);
    }

    @Override
    public void deleteAll() throws PortalException, SystemException {
        this._localRepository.deleteAll();
    }

    @Override
    public void deleteFileEntry(long fileEntryId) throws PortalException, SystemException {
        this._localRepository.deleteFileEntry(fileEntryId);
    }

    @Override
    public void deleteFolder(long folderId) throws PortalException, SystemException {
        this._localRepository.deleteFolder(folderId);
    }

    @Override
    public List<FileEntry> getFileEntries(long folderId, int start, int end, OrderByComparator obc) throws SystemException {
        List<FileEntry> fileEntries = this._localRepository.getFileEntries(folderId, start, end, obc);
        return this.toFileEntryProxyBeans(fileEntries);
    }

    @Override
    public List<Object> getFileEntriesAndFileShortcuts(long folderId, int status, int start, int end) throws SystemException {
        List<Object> objects = this._localRepository.getFileEntriesAndFileShortcuts(folderId, status, start, end);
        return this.toObjectProxyBeans(objects);
    }

    @Override
    public int getFileEntriesAndFileShortcutsCount(long folderId, int status) throws SystemException {
        return this._localRepository.getFileEntriesAndFileShortcutsCount(folderId, status);
    }

    @Override
    public int getFileEntriesCount(long folderId) throws SystemException {
        return this._localRepository.getFileEntriesCount(folderId);
    }

    @Override
    public FileEntry getFileEntry(long fileEntryId) throws PortalException, SystemException {
        FileEntry fileEntry = this._localRepository.getFileEntry(fileEntryId);
        return this.newFileEntryProxyBean(fileEntry);
    }

    @Override
    public FileEntry getFileEntry(long folderId, String title) throws PortalException, SystemException {
        FileEntry fileEntry = this._localRepository.getFileEntry(folderId, title);
        return this.newFileEntryProxyBean(fileEntry);
    }

    @Override
    public FileEntry getFileEntryByUuid(String uuid) throws PortalException, SystemException {
        FileEntry fileEntry = this._localRepository.getFileEntryByUuid(uuid);
        return this.newFileEntryProxyBean(fileEntry);
    }

    @Override
    public FileVersion getFileVersion(long fileVersionId) throws PortalException, SystemException {
        FileVersion fileVersion = this._localRepository.getFileVersion(fileVersionId);
        return this.newFileVersionProxyBean(fileVersion);
    }

    @Override
    public Folder getFolder(long folderId) throws PortalException, SystemException {
        Folder folder = this._localRepository.getFolder(folderId);
        return this.newFolderProxyBean(folder);
    }

    @Override
    public Folder getFolder(long parentFolderId, String title) throws PortalException, SystemException {
        return this._localRepository.getFolder(parentFolderId, title);
    }

    @Override
    public List<Folder> getFolders(long parentFolderId, boolean includeMountfolders, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        List<Folder> folderList = this._localRepository.getFolders(parentFolderId, includeMountfolders, start, end, obc);
        return this.toFolderProxyBeans(folderList);
    }

    @Override
    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws SystemException {
        List<Object> objects = this._localRepository.getFoldersAndFileEntriesAndFileShortcuts(folderId, status, includeMountFolders, start, end, obc);
        return this.toObjectProxyBeans(objects);
    }

    @Override
    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, String[] mimeTypes, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        List<Object> objects = this._localRepository.getFoldersAndFileEntriesAndFileShortcuts(folderId, status, mimeTypes, includeMountFolders, start, end, obc);
        return this.toObjectProxyBeans(objects);
    }

    @Override
    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, boolean includeMountFolders) throws SystemException {
        return this._localRepository.getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, includeMountFolders);
    }

    @Override
    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimeTypes, boolean includeMountFolders) throws PortalException, SystemException {
        return this._localRepository.getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, mimeTypes, includeMountFolders);
    }

    @Override
    public int getFoldersCount(long parentFolderId, boolean includeMountFolders) throws PortalException, SystemException {
        return this._localRepository.getFoldersCount(parentFolderId, includeMountFolders);
    }

    @Override
    public int getFoldersFileEntriesCount(List<Long> folderIds, int status) throws SystemException {
        return this._localRepository.getFoldersFileEntriesCount(folderIds, status);
    }

    @Override
    public List<Folder> getMountFolders(long parentFolderId, int start, int end, OrderByComparator obc) throws SystemException {
        List<Folder> folderList = this._localRepository.getMountFolders(parentFolderId, start, end, obc);
        return this.toFolderProxyBeans(folderList);
    }

    @Override
    public int getMountFoldersCount(long parentFolderId) throws SystemException {
        return this._localRepository.getMountFoldersCount(parentFolderId);
    }

    @Override
    public long getRepositoryId() {
        return this._localRepository.getRepositoryId();
    }

    @Override
    public FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        FileEntry fileEntry = this._localRepository.moveFileEntry(userId, fileEntryId, newFolderId, serviceContext);
        return this.newFileEntryProxyBean(fileEntry);
    }

    @Override
    public void updateAsset(long userId, FileEntry fileEntry, FileVersion fileVersion, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException, SystemException {
        this._localRepository.updateAsset(userId, fileEntry, fileVersion, assetCategoryIds, assetTagNames, assetLinkEntryIds);
    }

    @Override
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        FileEntry fileEntry = this._localRepository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, file, serviceContext);
        return this.newFileEntryProxyBean(fileEntry);
    }

    @Override
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        FileEntry fileEntry = this._localRepository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, is, size, serviceContext);
        return this.newFileEntryProxyBean(fileEntry);
    }

    @Override
    public Folder updateFolder(long folderId, long parentFolderId, String title, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        return this._localRepository.updateFolder(folderId, parentFolderId, title, description, serviceContext);
    }
}

