/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.FullNameGenerator;

public class DefaultFullNameGenerator
implements FullNameGenerator {
    private static Log _log = LogFactoryUtil.getLog(DefaultFullNameGenerator.class);

    public String getFullName(String firstName, String middleName, String lastName) {
        String fullName = this.buildFullName(firstName, middleName, lastName, false);
        if (fullName.length() <= 75) {
            return fullName;
        }
        if (_log.isInfoEnabled()) {
            StringBundler sb = new StringBundler(5);
            sb.append("Full name exceeds ");
            sb.append(75);
            sb.append(" characters for user ");
            sb.append(fullName);
            sb.append(". Full name has been shortened.");
            _log.info(sb.toString());
        }
        if ((fullName = this.buildFullName(firstName, middleName, lastName, true)).length() <= 75) {
            return fullName;
        }
        return fullName.substring(0, 75);
    }

    public String[] splitFullName(String fullName) {
        String firstName = "";
        String middleName = "";
        String lastName = "";
        if (Validator.isNotNull(fullName)) {
            String[] name = StringUtil.split(fullName, ' ');
            firstName = name[0];
            middleName = "";
            lastName = name[name.length - 1];
            if (name.length > 2) {
                int i = 1;
                while (i < name.length - 1) {
                    if (!Validator.isNull(name[i].trim())) {
                        if (i != 1) {
                            middleName = String.valueOf(middleName) + " ";
                        }
                        middleName = String.valueOf(middleName) + name[i].trim();
                    }
                    ++i;
                }
            }
        }
        return new String[]{firstName, middleName, lastName};
    }

    protected String buildFullName(String firstName, String middleName, String lastName, boolean useInitials) {
        StringBundler sb = new StringBundler(5);
        if (useInitials) {
            firstName = firstName.substring(0, 1);
        }
        sb.append(firstName);
        if (Validator.isNotNull(middleName)) {
            if (useInitials) {
                middleName = middleName.substring(0, 1);
            }
            sb.append(" ");
            sb.append(middleName);
        }
        if (Validator.isNotNull(lastName)) {
            sb.append(" ");
            sb.append(lastName);
        }
        return sb.toString();
    }
}

