/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.PortletPreferencesIds;
import com.liferay.portal.model.Role;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceContext
implements Cloneable,
Serializable {
    private boolean _addGroupPermissions;
    private boolean _addGuestPermissions;
    private long[] _assetCategoryIds;
    private boolean _assetEntryVisible = true;
    private long[] _assetLinkEntryIds;
    private String[] _assetTagNames;
    private Map<String, Serializable> _attributes = new LinkedHashMap<String, Serializable>();
    private String _command;
    private long _companyId;
    private Date _createDate;
    private String _currentURL;
    private boolean _deriveDefaultPermissions;
    private Map<String, Serializable> _expandoBridgeAttributes = new LinkedHashMap<String, Serializable>();
    private String[] _groupPermissions;
    private String[] _guestPermissions;
    private Map<String, String> _headers;
    private boolean _indexingEnabled = true;
    private String _languageId;
    private String _layoutFullURL;
    private String _layoutURL;
    private Date _modifiedDate;
    private String _pathMain;
    private String _portalURL;
    private PortletPreferencesIds _portletPreferencesIds;
    private String _remoteAddr;
    private String _remoteHost;
    private long _scopeGroupId;
    private boolean _signedIn;
    private String _userDisplayURL;
    private long _plid;
    private int _workflowAction = 1;
    private long _userId;
    private String _uuid;

    public Object clone() {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(this.isAddGroupPermissions());
        serviceContext.setAddGuestPermissions(this.isAddGuestPermissions());
        serviceContext.setAssetCategoryIds(this.getAssetCategoryIds());
        serviceContext.setAssetEntryVisible(this.isAssetEntryVisible());
        serviceContext.setAssetLinkEntryIds(this.getAssetLinkEntryIds());
        serviceContext.setAssetTagNames(this.getAssetTagNames());
        serviceContext.setAttributes(this.getAttributes());
        serviceContext.setCommand(this.getCommand());
        serviceContext.setCompanyId(this.getCompanyId());
        serviceContext.setCreateDate(this.getCreateDate());
        serviceContext.setCurrentURL(this.getCurrentURL());
        serviceContext.setExpandoBridgeAttributes(this.getExpandoBridgeAttributes());
        serviceContext.setGroupPermissions(this.getGroupPermissions());
        serviceContext.setGuestPermissions(this.getGuestPermissions());
        serviceContext.setHeaders(this.getHeaders());
        serviceContext.setIndexingEnabled(this.isIndexingEnabled());
        serviceContext.setLanguageId(this.getLanguageId());
        serviceContext.setLayoutFullURL(this.getLayoutFullURL());
        serviceContext.setLayoutURL(this.getLayoutURL());
        serviceContext.setModifiedDate(this.getModifiedDate());
        serviceContext.setPathMain(this.getPathMain());
        serviceContext.setPlid(this.getPlid());
        serviceContext.setPortalURL(this.getPortalURL());
        serviceContext.setPortletPreferencesIds(this.getPortletPreferencesIds());
        serviceContext.setRemoteAddr(this.getRemoteAddr());
        serviceContext.setRemoteHost(this.getRemoteHost());
        serviceContext.setScopeGroupId(this.getScopeGroupId());
        serviceContext.setSignedIn(this.isSignedIn());
        serviceContext.setUserDisplayURL(this.getUserDisplayURL());
        serviceContext.setUserId(this.getUserId());
        serviceContext.setUuid(this.getUuid());
        serviceContext.setWorkflowAction(this.getWorkflowAction());
        return serviceContext;
    }

    public void deriveDefaultPermissions(long repositoryId, String modelName) throws PortalException, SystemException {
        long parentGroupId = PortalUtil.getParentGroupId(repositoryId);
        Group parentGroup = GroupLocalServiceUtil.getGroup(parentGroupId);
        Role defaultGroupRole = RoleLocalServiceUtil.getDefaultGroupRole(parentGroupId);
        ArrayList<String> groupPermissions = new ArrayList<String>();
        ArrayList<String> guestPermissions = new ArrayList<String>();
        String[] roleNames = new String[]{"Guest", defaultGroupRole.getName()};
        List<String> supportedActions = ResourceActionsUtil.getModelResourceActions(modelName);
        List<String> groupDefaultActions = ResourceActionsUtil.getModelResourceGroupDefaultActions(modelName);
        List<String> guestDefaultActions = ResourceActionsUtil.getModelResourceGuestDefaultActions(modelName);
        List<String> guestUnsupportedActions = ResourceActionsUtil.getModelResourceGuestUnsupportedActions(modelName);
        String[] stringArray = roleNames;
        int n = roleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String roleName = stringArray[n2];
            for (String action : supportedActions) {
                if (roleName.equals("Guest") && !guestUnsupportedActions.contains(action) && guestDefaultActions.contains(action) && parentGroup.hasPublicLayouts()) {
                    guestPermissions.add(action);
                    continue;
                }
                if (!roleName.equals(defaultGroupRole.getName()) || !groupDefaultActions.contains(action)) continue;
                groupPermissions.add(action);
            }
            ++n2;
        }
        this.setGroupPermissions(groupPermissions.toArray(new String[groupPermissions.size()]));
        this.setGuestPermissions(guestPermissions.toArray(new String[guestPermissions.size()]));
    }

    public boolean getAddCommunityPermissions() {
        return this.isAddGroupPermissions();
    }

    public long[] getAssetCategoryIds() {
        return this._assetCategoryIds;
    }

    public long[] getAssetLinkEntryIds() {
        return this._assetLinkEntryIds;
    }

    public String[] getAssetTagNames() {
        return this._assetTagNames;
    }

    public Serializable getAttribute(String name) {
        return this._attributes.get(name);
    }

    public Map<String, Serializable> getAttributes() {
        return this._attributes;
    }

    public String getCommand() {
        return this._command;
    }

    public String[] getCommunityPermissions() {
        return this.getGroupPermissions();
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public Date getCreateDate() {
        return this._createDate;
    }

    public Date getCreateDate(Date defaultCreateDate) {
        if (this._createDate != null) {
            return this._createDate;
        }
        if (defaultCreateDate != null) {
            return defaultCreateDate;
        }
        return new Date();
    }

    public String getCurrentURL() {
        return this._currentURL;
    }

    public Map<String, Serializable> getExpandoBridgeAttributes() {
        return this._expandoBridgeAttributes;
    }

    public String[] getGroupPermissions() {
        return this._groupPermissions;
    }

    public long getGuestOrUserId() throws PortalException, SystemException {
        long userId = this.getUserId();
        if (userId > 0L) {
            return userId;
        }
        long companyId = this.getCompanyId();
        if (companyId > 0L) {
            return UserLocalServiceUtil.getDefaultUserId(this.getCompanyId());
        }
        return 0L;
    }

    public String[] getGuestPermissions() {
        return this._guestPermissions;
    }

    public Map<String, String> getHeaders() {
        return this._headers;
    }

    public String getLanguageId() {
        return this._languageId;
    }

    public String getLayoutFullURL() {
        return this._layoutFullURL;
    }

    public String getLayoutURL() {
        return this._layoutURL;
    }

    public Locale getLocale() {
        return LocaleUtil.fromLanguageId(this._languageId);
    }

    public Date getModifiedDate() {
        return this._modifiedDate;
    }

    public Date getModifiedDate(Date defaultModifiedDate) {
        if (this._modifiedDate != null) {
            return this._modifiedDate;
        }
        if (defaultModifiedDate != null) {
            return defaultModifiedDate;
        }
        return new Date();
    }

    public String getPathMain() {
        return this._pathMain;
    }

    public long getPlid() {
        return this._plid;
    }

    public String getPortalURL() {
        return this._portalURL;
    }

    public String getPortletId() {
        if (this._portletPreferencesIds != null) {
            return this._portletPreferencesIds.getPortletId();
        }
        return null;
    }

    public PortletPreferencesIds getPortletPreferencesIds() {
        return this._portletPreferencesIds;
    }

    public String getRemoteAddr() {
        return this._remoteAddr;
    }

    public String getRemoteHost() {
        return this._remoteHost;
    }

    public long getScopeGroupId() {
        return this._scopeGroupId;
    }

    public String getUserAgent() {
        if (this._headers == null) {
            return null;
        }
        return this._headers.get("User-Agent");
    }

    public String getUserDisplayURL() {
        return this._userDisplayURL;
    }

    public long getUserId() {
        return this._userId;
    }

    public String getUuid() {
        String uuid = this._uuid;
        this._uuid = null;
        return uuid;
    }

    public int getWorkflowAction() {
        return this._workflowAction;
    }

    public boolean isAddGuestPermissions() {
        return this._addGuestPermissions;
    }

    public boolean isAddGroupPermissions() {
        return this._addGroupPermissions;
    }

    public boolean isAssetEntryVisible() {
        return this._assetEntryVisible;
    }

    public boolean isCommandAdd() {
        return Validator.equals(this._command, "add");
    }

    public boolean isCommandUpdate() {
        return Validator.equals(this._command, "update");
    }

    public boolean isDeriveDefaultPermissions() {
        return this._deriveDefaultPermissions;
    }

    public boolean isIndexingEnabled() {
        return this._indexingEnabled;
    }

    public boolean isSignedIn() {
        return this._signedIn;
    }

    public Serializable removeAttribute(String name) {
        return this._attributes.remove(name);
    }

    public void setAddCommunityPermissions(boolean addCommunityPermissions) {
        this.setAddGroupPermissions(addCommunityPermissions);
    }

    public void setAddGroupPermissions(boolean addGroupPermissions) {
        this._addGroupPermissions = addGroupPermissions;
    }

    public void setAddGuestPermissions(boolean addGuestPermissions) {
        this._addGuestPermissions = addGuestPermissions;
    }

    public void setAssetCategoryIds(long[] assetCategoryIds) {
        this._assetCategoryIds = assetCategoryIds;
    }

    public void setAssetEntryVisible(boolean assetEntryVisible) {
        this._assetEntryVisible = assetEntryVisible;
    }

    public void setAssetLinkEntryIds(long[] assetLinkEntryIds) {
        this._assetLinkEntryIds = assetLinkEntryIds;
    }

    public void setAssetTagNames(String[] assetTagNames) {
        this._assetTagNames = assetTagNames;
    }

    public void setAttribute(String name, Serializable value) {
        this._attributes.put(name, value);
    }

    public void setAttributes(Map<String, Serializable> attributes) {
        this._attributes = attributes;
    }

    public void setCommand(String command) {
        this._command = command;
    }

    public void setCommunityPermissions(String[] communityPermissions) {
        this.setGroupPermissions(communityPermissions);
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public void setCreateDate(Date createDate) {
        this._createDate = createDate;
    }

    public void setCurrentURL(String currentURL) {
        this._currentURL = currentURL;
    }

    public void setDeriveDefaultPermissions(boolean deriveDefaultPermissions) {
        this._deriveDefaultPermissions = deriveDefaultPermissions;
    }

    public void setExpandoBridgeAttributes(Map<String, Serializable> expandoBridgeAttributes) {
        this._expandoBridgeAttributes = expandoBridgeAttributes;
    }

    public void setGroupPermissions(String[] groupPermissions) {
        this._groupPermissions = groupPermissions;
    }

    public void setGuestPermissions(String[] guestPermissions) {
        this._guestPermissions = guestPermissions;
    }

    public void setHeaders(Map<String, String> headers) {
        this._headers = headers;
    }

    public void setIndexingEnabled(boolean indexingEnabled) {
        this._indexingEnabled = indexingEnabled;
    }

    public void setLanguageId(String languageId) {
        this._languageId = languageId;
    }

    public void setLayoutFullURL(String layoutFullURL) {
        this._layoutFullURL = layoutFullURL;
    }

    public void setLayoutURL(String layoutURL) {
        this._layoutURL = layoutURL;
    }

    public void setModifiedDate(Date modifiedDate) {
        this._modifiedDate = modifiedDate;
    }

    public void setPathMain(String pathMain) {
        this._pathMain = pathMain;
    }

    public void setPlid(long plid) {
        this._plid = plid;
    }

    public void setPortalURL(String portalURL) {
        this._portalURL = portalURL;
    }

    public void setPortletPreferencesIds(PortletPreferencesIds portletPreferencesIds) {
        this._portletPreferencesIds = portletPreferencesIds;
    }

    public void setRemoteAddr(String remoteAddr) {
        this._remoteAddr = remoteAddr;
    }

    public void setRemoteHost(String remoteHost) {
        this._remoteHost = remoteHost;
    }

    public void setScopeGroupId(long scopeGroupId) {
        this._scopeGroupId = scopeGroupId;
    }

    public void setSignedIn(boolean signedIn) {
        this._signedIn = signedIn;
    }

    public void setUserDisplayURL(String userDisplayURL) {
        this._userDisplayURL = userDisplayURL;
    }

    public void setUserId(long userId) {
        this._userId = userId;
    }

    public void setUuid(String uuid) {
        this._uuid = uuid;
    }

    public void setWorkflowAction(int workflowAction) {
        this._workflowAction = workflowAction;
    }

    public String translate(String pattern, Object ... arguments) {
        Locale locale = this.getLocale();
        return LanguageUtil.format(locale, pattern, arguments);
    }
}

