/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import javax.servlet.http.HttpServletRequest;

public class SessionClicks {
    private static final String _DEFAULT_NAMESPACE = SessionClicks.class.getName();
    private static Log _log = LogFactoryUtil.getLog(SessionClicks.class);

    public static String get(HttpServletRequest request, String key, String defaultValue) {
        return SessionClicks.get(request, _DEFAULT_NAMESPACE, key, defaultValue);
    }

    public static String get(HttpServletRequest request, String namespace, String key, String defaultValue) {
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences(request);
            return preferences.getValue(namespace, key, defaultValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            return null;
        }
    }

    public static void put(HttpServletRequest request, String key, String value) {
        SessionClicks.put(request, _DEFAULT_NAMESPACE, key, value);
    }

    public static void put(HttpServletRequest request, String namespace, String key, String value) {
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences(request);
            preferences.setValue(namespace, key, value);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }
}

