/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.util.comparator;

import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portlet.blogs.model.BlogsEntry;

public class EntryDisplayDateComparator
extends OrderByComparator {
    public static final String ORDER_BY_ASC = "BlogsEntry.displayDate ASC, BlogsEntry.entryId ASC";
    public static final String ORDER_BY_DESC = "BlogsEntry.displayDate DESC, BlogsEntry.entryId DESC";
    public static final String[] ORDER_BY_CONDITION_FIELDS = new String[]{"displayDate"};
    public static final String[] ORDER_BY_FIELDS = new String[]{"displayDate", "entryId"};
    private boolean _ascending;

    public EntryDisplayDateComparator() {
        this(false);
    }

    public EntryDisplayDateComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public int compare(Object obj1, Object obj2) {
        BlogsEntry entry1 = (BlogsEntry)obj1;
        BlogsEntry entry2 = (BlogsEntry)obj2;
        int value = DateUtil.compareTo(entry1.getDisplayDate(), entry2.getDisplayDate());
        if (value == 0) {
            if (entry1.getEntryId() < entry2.getEntryId()) {
                value = -1;
            } else if (entry1.getEntryId() > entry2.getEntryId()) {
                value = 1;
            }
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByConditionFields() {
        return ORDER_BY_CONDITION_FIELDS;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }
}

