/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util.comparator;

import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;

public class RepositoryModelReadCountComparator
extends OrderByComparator {
    public static final String ORDER_BY_ASC = "readCount ASC";
    public static final String ORDER_BY_DESC = "readCount DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"readCount"};
    private boolean _ascending;

    public RepositoryModelReadCountComparator() {
        this(false);
    }

    public RepositoryModelReadCountComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public int compare(Object obj1, Object obj2) {
        Long readCount1 = this.getReadCount(obj1);
        Long readCount2 = this.getReadCount(obj2);
        int value = readCount1.compareTo(readCount2);
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }

    protected long getReadCount(Object obj) {
        if (obj instanceof DLFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)obj;
            return dlFileEntry.getReadCount();
        }
        if (obj instanceof DLFileShortcut) {
            DLFileShortcut dlFileShortcut = (DLFileShortcut)obj;
            long toFileEntryId = dlFileShortcut.getToFileEntryId();
            try {
                DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.getFileEntry(toFileEntryId);
                return dlFileEntry.getReadCount();
            }
            catch (Exception exception) {
                return 0L;
            }
        }
        if (obj instanceof DLFolder || obj instanceof Folder) {
            return 0L;
        }
        FileEntry fileEntry = (FileEntry)obj;
        return fileEntry.getReadCount();
    }
}

