/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.util.comparator;

import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portlet.shopping.model.ShoppingItem;

public class ItemMinQuantityComparator
extends OrderByComparator {
    public static final String ORDER_BY_ASC = "ShoppingItem.categoryId ASC, ShoppingItem.minQuantity ASC, ShoppingItem.name ASC";
    public static final String ORDER_BY_DESC = "ShoppingItem.categoryId DESC, ShoppingItem.minQuantity DESC, ShoppingItem.name DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"categoryId", "minQuantity", "name"};
    private boolean _ascending;

    public ItemMinQuantityComparator() {
        this(false);
    }

    public ItemMinQuantityComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public int compare(Object obj1, Object obj2) {
        Long categoryId2;
        ShoppingItem item1 = (ShoppingItem)obj1;
        ShoppingItem item2 = (ShoppingItem)obj2;
        Long categoryId1 = new Long(item1.getCategoryId());
        int value = categoryId1.compareTo(categoryId2 = new Long(item2.getCategoryId()));
        if (value == 0) {
            if (item1.getMinQuantity() < item2.getMinQuantity()) {
                value = -1;
            } else if (item1.getMinQuantity() > item2.getMinQuantity()) {
                value = 1;
            }
        }
        if (value == 0) {
            value = item1.getName().toLowerCase().compareTo(item2.getName().toLowerCase());
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }
}

