/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.backgroundtask;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusMessageTranslator;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;

public abstract class BaseBackgroundTaskExecutor
implements BackgroundTaskExecutor {
    private static Log _log = LogFactoryUtil.getLog(BaseBackgroundTaskExecutor.class);
    private BackgroundTaskStatusMessageTranslator _backgroundTaskStatusMessageTranslator;
    private boolean _serial;

    @Override
    public BackgroundTaskStatusMessageTranslator getBackgroundTaskStatusMessageTranslator() {
        return this._backgroundTaskStatusMessageTranslator;
    }

    @Override
    public String handleException(BackgroundTask backgroundTask, Exception e) throws SystemException {
        return "Unable to execute background task: " + e.getMessage();
    }

    @Override
    public boolean isSerial() {
        return this._serial;
    }

    protected Locale getLocale(BackgroundTask backgroundTask) {
        block4: {
            Map<String, Serializable> taskContextMap = backgroundTask.getTaskContextMap();
            long userId = MapUtil.getLong(taskContextMap, "userId");
            if (userId > 0L) {
                try {
                    User user = UserLocalServiceUtil.fetchUser(userId);
                    if (user != null) {
                        return user.getLocale();
                    }
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug("Unable to get the user's locale", e);
                }
            }
        }
        return LocaleUtil.getDefault();
    }

    protected void setBackgroundTaskStatusMessageTranslator(BackgroundTaskStatusMessageTranslator backgroundTaskStatusMessageTranslator) {
        this._backgroundTaskStatusMessageTranslator = backgroundTaskStatusMessageTranslator;
    }

    protected void setSerial(boolean serial) {
        this._serial = serial;
    }
}

