/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.lar;

import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.PortletDataHandlerStatusMessageSenderUtil;
import com.liferay.portal.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.model.TrashedModel;
import com.liferay.portal.model.WorkflowedModel;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseStagedModelDataHandler<T extends StagedModel>
implements StagedModelDataHandler<T> {
    @Override
    public abstract void deleteStagedModel(String var1, long var2, String var4, String var5) throws PortalException, SystemException;

    @Override
    public void exportStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        this.validateExport(portletDataContext, stagedModel);
        String path = ExportImportPathUtil.getModelPath(stagedModel);
        if (portletDataContext.isPathExportedInScope(path)) {
            return;
        }
        try {
            ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
            PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage("stagedModel", stagedModel, manifestSummary);
            this.doExportStagedModel(portletDataContext, (StagedModel)stagedModel.clone());
            if (this.countStagedModel(portletDataContext, stagedModel)) {
                manifestSummary.incrementModelAdditionCount(stagedModel.getStagedModelType());
            }
            portletDataContext.cleanUpMissingReferences((ClassedModel)stagedModel);
        }
        catch (PortletDataException pde) {
            throw pde;
        }
        catch (Exception e) {
            PortletDataException pde = new PortletDataException(e);
            if (e instanceof NoSuchModelException) {
                pde.setStagedModel((StagedModel)stagedModel);
                pde.setType(5);
            }
            throw pde;
        }
    }

    @Override
    public abstract String[] getClassNames();

    @Override
    public String getDisplayName(T stagedModel) {
        return stagedModel.getUuid();
    }

    @Override
    public int[] getExportableStatuses() {
        return new int[1];
    }

    @Override
    public Map<String, String> getReferenceAttributes(PortletDataContext portletDataContext, T stagedModel) {
        return new HashMap<String, String>();
    }

    @Override
    public void importCompanyStagedModel(PortletDataContext portletDataContext, Element element) throws PortletDataException {
        String uuid = element.attributeValue("uuid");
        long classPK = GetterUtil.getLong(element.attributeValue("class-pk"));
        this.importCompanyStagedModel(portletDataContext, uuid, classPK);
    }

    @Override
    public void importCompanyStagedModel(PortletDataContext portletDataContext, String uuid, long classPK) throws PortletDataException {
        try {
            this.doImportCompanyStagedModel(portletDataContext, uuid, classPK);
        }
        catch (PortletDataException pde) {
            throw pde;
        }
        catch (Exception e) {
            throw new PortletDataException(e);
        }
    }

    @Override
    public void importStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        String path = ExportImportPathUtil.getModelPath(stagedModel);
        if (portletDataContext.isPathProcessed(path)) {
            return;
        }
        try {
            ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
            PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage("stagedModel", stagedModel, manifestSummary);
            if (stagedModel instanceof TrashedModel) {
                this.restoreStagedModel(portletDataContext, stagedModel);
            }
            this.doImportStagedModel(portletDataContext, stagedModel);
            manifestSummary.incrementModelAdditionCount(stagedModel.getStagedModelType());
        }
        catch (PortletDataException pde) {
            throw pde;
        }
        catch (Exception e) {
            throw new PortletDataException(e);
        }
    }

    @Override
    public void restoreStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        try {
            this.doRestoreStagedModel(portletDataContext, stagedModel);
        }
        catch (PortletDataException pde) {
            throw pde;
        }
        catch (Exception e) {
            throw new PortletDataException(e);
        }
    }

    @Override
    public boolean validateReference(PortletDataContext portletDataContext, Element referenceElement) {
        String uuid = referenceElement.attributeValue("uuid");
        try {
            boolean valid = this.validateMissingReference(uuid, portletDataContext.getCompanyId(), portletDataContext.getScopeGroupId());
            if (!valid) {
                valid = this.validateMissingReference(uuid, portletDataContext.getCompanyId(), portletDataContext.getCompanyGroupId());
            }
            return valid;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean countStagedModel(PortletDataContext portletDataContext, T stagedModel) {
        return !portletDataContext.isStagedModelCounted((StagedModel)stagedModel);
    }

    protected abstract void doExportStagedModel(PortletDataContext var1, T var2) throws Exception;

    protected void doImportCompanyStagedModel(PortletDataContext portletDataContext, String uuid, long classPK) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected abstract void doImportStagedModel(PortletDataContext var1, T var2) throws Exception;

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, T stagedModel) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void validateExport(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        TrashedModel trashedModel;
        if (stagedModel instanceof WorkflowedModel) {
            WorkflowedModel workflowedModel = (WorkflowedModel)stagedModel;
            if (!ArrayUtil.contains(this.getExportableStatuses(), workflowedModel.getStatus())) {
                PortletDataException pde = new PortletDataException(9);
                pde.setStagedModel((StagedModel)stagedModel);
                throw pde;
            }
        }
        if (stagedModel instanceof TrashedModel && (trashedModel = (TrashedModel)stagedModel).isInTrash()) {
            PortletDataException pde = new PortletDataException(8);
            pde.setStagedModel((StagedModel)stagedModel);
            throw pde;
        }
    }

    protected boolean validateMissingReference(String uuid, long companyId, long groupId) throws Exception {
        return true;
    }
}

