/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.lar;

import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LongWrapper;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Portlet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ManifestSummary
implements Serializable {
    private Map<String, String[]> _configurationPortletOptions = new HashMap<String, String[]>();
    private List<Portlet> _configurationPortlets = new ArrayList<Portlet>();
    private List<Portlet> _dataPortlets = new ArrayList<Portlet>();
    private Set<String> _dataRootPortletIds = new HashSet<String>();
    private Date _exportDate;
    private Set<String> _manifestSummaryKeys = new HashSet<String>();
    private Map<String, LongWrapper> _modelAdditionCounters = new HashMap<String, LongWrapper>();
    private Map<String, LongWrapper> _modelDeletionCounters = new HashMap<String, LongWrapper>();

    public static String getManifestSummaryKey(String modelName, String referrerModelName) {
        if (Validator.isNull(referrerModelName) || modelName.equals(referrerModelName)) {
            return modelName;
        }
        return modelName.concat("#").concat(referrerModelName);
    }

    public void addConfigurationPortlet(Portlet portlet, String[] configurationPortletOptions) {
        String rootPortletId = portlet.getRootPortletId();
        if (!this._configurationPortletOptions.containsKey(rootPortletId)) {
            this._configurationPortlets.add(portlet);
            this._configurationPortletOptions.put(rootPortletId, configurationPortletOptions);
        }
    }

    public void addDataPortlet(Portlet portlet) {
        String rootPortletId = portlet.getRootPortletId();
        if (!this._dataRootPortletIds.contains(rootPortletId)) {
            this._dataPortlets.add(portlet);
            this._dataRootPortletIds.add(rootPortletId);
        }
    }

    public void addModelAdditionCount(StagedModelType stagedModelType, long count) {
        this.addModelAdditionCount(stagedModelType.toString(), count);
    }

    public void addModelAdditionCount(String manifestSummaryKey, long count) {
        LongWrapper modelAdditionCounter = this._modelAdditionCounters.get(manifestSummaryKey);
        if (modelAdditionCounter == null) {
            modelAdditionCounter = new LongWrapper();
            this._modelAdditionCounters.put(manifestSummaryKey, modelAdditionCounter);
        }
        modelAdditionCounter.setValue(count);
        this._manifestSummaryKeys.add(manifestSummaryKey);
    }

    public void addModelDeletionCount(String manifestSummaryKey, long count) {
        LongWrapper modelDeletionCounter = this._modelDeletionCounters.get(manifestSummaryKey);
        if (modelDeletionCounter == null) {
            modelDeletionCounter = new LongWrapper();
            this._modelDeletionCounters.put(manifestSummaryKey, modelDeletionCounter);
        }
        modelDeletionCounter.setValue(count);
        this._manifestSummaryKeys.add(manifestSummaryKey);
    }

    public Object clone() {
        ManifestSummary manifestSummary = new ManifestSummary();
        manifestSummary._configurationPortletOptions = new HashMap<String, String[]>(manifestSummary._configurationPortletOptions);
        manifestSummary._configurationPortlets = new ArrayList<Portlet>(this._configurationPortlets);
        manifestSummary._dataPortlets = new ArrayList<Portlet>(this._dataPortlets);
        manifestSummary._dataRootPortletIds = new HashSet<String>(this._dataRootPortletIds);
        if (this._exportDate != null) {
            manifestSummary.setExportDate(new Date(this._exportDate.getTime()));
        }
        manifestSummary._manifestSummaryKeys = new HashSet<String>(this._manifestSummaryKeys);
        manifestSummary._modelAdditionCounters = new HashMap<String, LongWrapper>(this._modelAdditionCounters);
        manifestSummary._modelDeletionCounters = new HashMap<String, LongWrapper>(this._modelDeletionCounters);
        return manifestSummary;
    }

    public String[] getConfigurationPortletOptions(String rootPortletId) {
        return this._configurationPortletOptions.get(rootPortletId);
    }

    public List<Portlet> getConfigurationPortlets() {
        return this._configurationPortlets;
    }

    public List<Portlet> getDataPortlets() {
        return this._dataPortlets;
    }

    public Date getExportDate() {
        return this._exportDate;
    }

    public Collection<String> getManifestSummaryKeys() {
        return this._manifestSummaryKeys;
    }

    public long getModelAdditionCount(Class<? extends ClassedModel> clazz) {
        return this.getModelAdditionCount(clazz, clazz);
    }

    public long getModelAdditionCount(Class<? extends ClassedModel> clazz, Class<? extends ClassedModel> referrerClass) {
        return this.getModelAdditionCount(clazz.getName(), referrerClass.getName());
    }

    public long getModelAdditionCount(String manifestSummaryKey) {
        if (!this._modelAdditionCounters.containsKey(manifestSummaryKey)) {
            return -1L;
        }
        LongWrapper modelAdditionCounter = this._modelAdditionCounters.get(manifestSummaryKey);
        return modelAdditionCounter.getValue();
    }

    public long getModelAdditionCount(String className, String referrerClassName) {
        String manifestSummaryKey = ManifestSummary.getManifestSummaryKey(className, referrerClassName);
        return this.getModelAdditionCount(manifestSummaryKey);
    }

    public Map<String, LongWrapper> getModelAdditionCounters() {
        return this._modelAdditionCounters;
    }

    public long getModelDeletionCount() {
        long modelDeletionCount = -1L;
        for (String manifestSummaryKey : this._manifestSummaryKeys) {
            long manifestSummaryKeyModelDeletionCount = this.getModelDeletionCount(manifestSummaryKey);
            if (manifestSummaryKeyModelDeletionCount == -1L) continue;
            if (modelDeletionCount == -1L) {
                modelDeletionCount = manifestSummaryKeyModelDeletionCount;
                continue;
            }
            modelDeletionCount += manifestSummaryKeyModelDeletionCount;
        }
        return modelDeletionCount;
    }

    public long getModelDeletionCount(Class<? extends ClassedModel> clazz) {
        return this.getModelDeletionCount(clazz.getName());
    }

    public long getModelDeletionCount(StagedModelType[] stagedModelTypes) {
        if (ArrayUtil.isEmpty(stagedModelTypes)) {
            return 0L;
        }
        long modelDeletionCount = -1L;
        StagedModelType[] stagedModelTypeArray = stagedModelTypes;
        int n = stagedModelTypes.length;
        int n2 = 0;
        while (n2 < n) {
            StagedModelType stagedModelType = stagedModelTypeArray[n2];
            long stagedModelTypeModelDeletionCount = this.getModelDeletionCount(stagedModelType.toString());
            if (stagedModelTypeModelDeletionCount != -1L) {
                modelDeletionCount = modelDeletionCount == -1L ? stagedModelTypeModelDeletionCount : (modelDeletionCount += stagedModelTypeModelDeletionCount);
            }
            ++n2;
        }
        return modelDeletionCount;
    }

    public long getModelDeletionCount(String modelName) {
        if (!this._modelDeletionCounters.containsKey(modelName)) {
            return -1L;
        }
        LongWrapper modelDeletionCounter = this._modelDeletionCounters.get(modelName);
        return modelDeletionCounter.getValue();
    }

    public Map<String, LongWrapper> getModelDeletionCounters() {
        return this._modelDeletionCounters;
    }

    public void incrementModelAdditionCount(StagedModelType stagedModelType) {
        String manifestSummaryKey = stagedModelType.toString();
        if (!this._modelAdditionCounters.containsKey(manifestSummaryKey)) {
            this._modelAdditionCounters.put(manifestSummaryKey, new LongWrapper(1L));
            this._manifestSummaryKeys.add(manifestSummaryKey);
            return;
        }
        LongWrapper modelAdditionCounter = this._modelAdditionCounters.get(manifestSummaryKey);
        modelAdditionCounter.increment();
    }

    public void incrementModelDeletionCount(StagedModelType stagedModelType) {
        String manifestSummaryKey = stagedModelType.toString();
        if (!this._modelDeletionCounters.containsKey(manifestSummaryKey)) {
            this._modelDeletionCounters.put(manifestSummaryKey, new LongWrapper(1L));
            this._manifestSummaryKeys.add(manifestSummaryKey);
            return;
        }
        LongWrapper modelDeletionCounter = this._modelDeletionCounters.get(manifestSummaryKey);
        modelDeletionCounter.increment();
    }

    public void resetCounters() {
        this._modelAdditionCounters.clear();
        this._modelDeletionCounters.clear();
        this._manifestSummaryKeys.clear();
    }

    public void setExportDate(Date exportDate) {
        this._exportDate = exportDate;
    }

    public String toString() {
        StringBundler sb = new StringBundler(5);
        sb.append("{modelAdditionCounters=");
        sb.append(MapUtil.toString(this._modelAdditionCounters));
        sb.append(", modelDeletionCounters=");
        sb.append(MapUtil.toString(this._modelDeletionCounters));
        sb.append("}");
        return sb.toString();
    }
}

