/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class DynamicServletRequest
extends HttpServletRequestWrapper {
    public static final String DYNAMIC_QUERY_STRING = "DYNAMIC_QUERY_STRING";
    private boolean _inherit;
    private Map<String, String[]> _params = new HashMap<String, String[]>();

    public static HttpServletRequest addQueryString(HttpServletRequest request, String queryString) {
        return DynamicServletRequest.addQueryString(request, queryString, true);
    }

    public static HttpServletRequest addQueryString(HttpServletRequest request, String queryString, boolean inherit) {
        String[] parameters = StringUtil.split(queryString, '&');
        if (parameters.length == 0) {
            return request;
        }
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        String[] stringArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String[] values;
            String parameter = stringArray[n2];
            String[] parameterParts = StringUtil.split(parameter, '=');
            String name = parameterParts[0];
            String value = "";
            if (parameterParts.length == 2) {
                value = parameterParts[1];
            }
            if ((values = (String[])parameterMap.get(name)) == null) {
                parameterMap.put(name, new String[]{value});
            } else {
                String[] newValues = new String[values.length + 1];
                System.arraycopy(values, 0, newValues, 0, values.length);
                newValues[newValues.length - 1] = value;
                parameterMap.put(name, newValues);
            }
            ++n2;
        }
        request = new DynamicServletRequest((HttpServletRequest)request, (Map<String, String[]>)parameterMap, inherit);
        request.setAttribute(DYNAMIC_QUERY_STRING, (Object)queryString);
        return request;
    }

    public DynamicServletRequest(HttpServletRequest request) {
        this(request, null, true);
    }

    public DynamicServletRequest(HttpServletRequest request, boolean inherit) {
        this(request, null, inherit);
    }

    public DynamicServletRequest(HttpServletRequest request, Map<String, String[]> params) {
        this(request, params, true);
    }

    public DynamicServletRequest(HttpServletRequest request, Map<String, String[]> params, boolean inherit) {
        super(request);
        this._inherit = inherit;
        if (params != null) {
            this._params.putAll(params);
        }
        if (this._inherit && request instanceof DynamicServletRequest) {
            DynamicServletRequest dynamicRequest = (DynamicServletRequest)request;
            this.setRequest(dynamicRequest.getRequest());
            params = dynamicRequest.getDynamicParameterMap();
            for (Map.Entry<String, String[]> entry : params.entrySet()) {
                String name = entry.getKey();
                String[] oldValues = entry.getValue();
                String[] curValues = this._params.get(name);
                if (curValues == null) {
                    this._params.put(name, oldValues);
                    continue;
                }
                String[] newValues = ArrayUtil.append(oldValues, curValues);
                this._params.put(name, newValues);
            }
        }
    }

    public void appendParameter(String name, String value) {
        String[] values = this._params.get(name);
        if (values == null) {
            values = new String[]{value};
        } else {
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[newValues.length - 1] = value;
            values = newValues;
        }
        this._params.put(name, values);
    }

    public Map<String, String[]> getDynamicParameterMap() {
        return this._params;
    }

    public String getParameter(String name) {
        Object[] values = this._params.get(name);
        if (this._inherit && values == null) {
            return super.getParameter(name);
        }
        if (ArrayUtil.isNotEmpty(values)) {
            return values[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        if (this._inherit) {
            map.putAll(super.getParameterMap());
        }
        map.putAll(this._params);
        return map;
    }

    public Enumeration<String> getParameterNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (this._inherit) {
            Enumeration enu = super.getParameterNames();
            while (enu.hasMoreElements()) {
                names.add((String)enu.nextElement());
            }
        }
        names.addAll(this._params.keySet());
        return Collections.enumeration(names);
    }

    public String[] getParameterValues(String name) {
        String[] values = this._params.get(name);
        if (this._inherit && values == null) {
            return super.getParameterValues(name);
        }
        return values;
    }

    public void setParameter(String name, String value) {
        this._params.put(name, new String[]{value});
    }

    public void setParameterValues(String name, String[] values) {
        this._params.put(name, values);
    }
}

