/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.UniqueList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class ReflectionUtil {
    public static Class<?> getAnnotationDeclaringClass(Class<? extends Annotation> annotationClass, Class<?> clazz) {
        if (clazz == null || clazz.equals(Object.class)) {
            return null;
        }
        if (ReflectionUtil.isAnnotationDeclaredInClass(annotationClass, clazz)) {
            return clazz;
        }
        return ReflectionUtil.getAnnotationDeclaringClass(annotationClass, clazz.getSuperclass());
    }

    public static Method getBridgeMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws Exception {
        return ReflectionUtil.getBridgeMethod(true, clazz, name, parameterTypes);
    }

    public static Method getDeclaredBridgeMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws Exception {
        return ReflectionUtil.getBridgeMethod(false, clazz, name, parameterTypes);
    }

    public static Field getDeclaredField(Class<?> clazz, String name) throws Exception {
        int modifiers;
        Field field = clazz.getDeclaredField(name);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        if (((modifiers = field.getModifiers()) & 0x10) == 16) {
            Field modifiersField = ReflectionUtil.getDeclaredField(Field.class, "modifiers");
            modifiersField.setInt(field, modifiers & 0xFFFFFFEF);
        }
        return field;
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws Exception {
        Method method = clazz.getDeclaredMethod(name, parameterTypes);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Class<?>[] getInterfaces(Object object) {
        return ReflectionUtil.getInterfaces(object, null);
    }

    public static Class<?>[] getInterfaces(Object object, ClassLoader classLoader) {
        UniqueList interfaceClasses = new UniqueList();
        Class<?> clazz = object.getClass();
        ReflectionUtil._getInterfaces(interfaceClasses, clazz, classLoader);
        Class<?> superClass = clazz.getSuperclass();
        while (superClass != null) {
            ReflectionUtil._getInterfaces(interfaceClasses, superClass, classLoader);
            superClass = superClass.getSuperclass();
        }
        return interfaceClasses.toArray(new Class[interfaceClasses.size()]);
    }

    public static Class<?>[] getParameterTypes(Object[] arguments) {
        if (arguments == null) {
            return null;
        }
        Class[] parameterTypes = new Class[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            parameterTypes[i] = arguments[i] == null ? null : (arguments[i] instanceof Boolean ? Boolean.TYPE : (arguments[i] instanceof Byte ? Byte.TYPE : (arguments[i] instanceof Character ? Character.TYPE : (arguments[i] instanceof Double ? Double.TYPE : (arguments[i] instanceof Float ? Float.TYPE : (arguments[i] instanceof Integer ? Integer.TYPE : (arguments[i] instanceof Long ? Long.TYPE : (arguments[i] instanceof Short ? Short.TYPE : arguments[i].getClass()))))))));
            ++i;
        }
        return parameterTypes;
    }

    public static boolean isAnnotationDeclaredInClass(Class<? extends Annotation> annotationClass, Class<?> clazz) {
        Annotation[] annotations;
        if (annotationClass == null || clazz == null) {
            throw new IllegalArgumentException();
        }
        Annotation[] annotationArray = annotations = clazz.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotationClass.equals(annotation.annotationType())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T extends Enum<T>> T newEnumElement(Class<T> enumClass, Class<?>[] constructorParameterTypes, String name, int ordinal, Object ... constructorParameters) throws Exception {
        Class[] parameterTypes = null;
        if (constructorParameterTypes != null && constructorParameterTypes.length != 0) {
            parameterTypes = new Class[constructorParameterTypes.length + 2];
            parameterTypes[0] = String.class;
            parameterTypes[1] = Integer.TYPE;
            System.arraycopy(constructorParameterTypes, 0, parameterTypes, 2, constructorParameterTypes.length);
        } else {
            parameterTypes = new Class[]{String.class, Integer.TYPE};
        }
        Constructor<T> constructor = enumClass.getDeclaredConstructor(parameterTypes);
        Method acquireConstructorAccessorMethod = ReflectionUtil.getDeclaredMethod(Constructor.class, "acquireConstructorAccessor", new Class[0]);
        acquireConstructorAccessorMethod.invoke(constructor, new Object[0]);
        Field constructorAccessorField = ReflectionUtil.getDeclaredField(Constructor.class, "constructorAccessor");
        Object constructorAccessor = constructorAccessorField.get(constructor);
        Method newInstanceMethod = ReflectionUtil.getDeclaredMethod(constructorAccessor.getClass(), "newInstance", Object[].class);
        Object[] parameters = null;
        if (constructorParameters != null && constructorParameters.length != 0) {
            parameters = new Object[constructorParameters.length + 2];
            parameters[0] = name;
            parameters[1] = ordinal;
            System.arraycopy(constructorParameters, 0, parameters, 2, constructorParameters.length);
        } else {
            parameters = new Object[]{name, ordinal};
        }
        return (T)((Enum)newInstanceMethod.invoke(constructorAccessor, new Object[]{parameters}));
    }

    public static <T extends Enum<T>> T newEnumElement(Class<T> enumClass, String name, int ordinal) throws Exception {
        return ReflectionUtil.newEnumElement(enumClass, null, name, ordinal, null);
    }

    protected static Method getBridgeMethod(boolean publicMethod, Class<?> clazz, String name, Class<?> ... parameterTypes) throws Exception {
        Method method = null;
        method = publicMethod ? clazz.getMethod(name, parameterTypes) : clazz.getDeclaredMethod(name, parameterTypes);
        if (method.isBridge()) {
            return method;
        }
        Method[] methods = null;
        methods = publicMethod ? clazz.getMethods() : clazz.getDeclaredMethods();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                Class<?>[] currentParameterTypes;
                Method currentMethod = methodArray[n2];
                if (currentMethod.isBridge() && name.equals(currentMethod.getName()) && (currentParameterTypes = currentMethod.getParameterTypes()).length == parameterTypes.length) {
                    int i = 0;
                    while (i < currentParameterTypes.length) {
                        if (currentParameterTypes[i].isAssignableFrom(parameterTypes[i])) {
                            ++i;
                            continue;
                        }
                        break block5;
                    }
                    return currentMethod;
                }
            }
            ++n2;
        }
        throw new NoSuchMethodException("No bridge method on " + clazz + " with name " + name + " and parameter types " + Arrays.toString(parameterTypes));
    }

    private static void _getInterfaces(List<Class<?>> interfaceClasses, Class<?> clazz, ClassLoader classLoader) {
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaceClass = classArray[n2];
            try {
                if (classLoader != null) {
                    interfaceClasses.add(classLoader.loadClass(interfaceClass.getName()));
                } else {
                    interfaceClasses.add(interfaceClass);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
            ++n2;
        }
    }
}

