/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.persistence;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.persistence.BlogsEntryActionableDynamicQuery;

public class BlogsEntryExportActionableDynamicQuery
extends BlogsEntryActionableDynamicQuery {
    private PortletDataContext _portletDataContext;

    public BlogsEntryExportActionableDynamicQuery(PortletDataContext portletDataContext) throws SystemException {
        this._portletDataContext = portletDataContext;
        this.setCompanyId(this._portletDataContext.getCompanyId());
        this.setGroupId(this._portletDataContext.getScopeGroupId());
    }

    @Override
    public long performCount() throws PortalException, SystemException {
        ManifestSummary manifestSummary = this._portletDataContext.getManifestSummary();
        StagedModelType stagedModelType = this.getStagedModelType();
        long modelAdditionCount = super.performCount();
        manifestSummary.addModelAdditionCount(stagedModelType.toString(), modelAdditionCount);
        long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount(this._portletDataContext, stagedModelType);
        manifestSummary.addModelDeletionCount(stagedModelType.toString(), modelDeletionCount);
        return modelAdditionCount;
    }

    @Override
    protected void addCriteria(DynamicQuery dynamicQuery) {
        this._portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
        StagedModelDataHandler<?> stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(BlogsEntry.class.getName());
        Property workflowStatusProperty = PropertyFactoryUtil.forName("status");
        dynamicQuery.add(workflowStatusProperty.in(stagedModelDataHandler.getExportableStatuses()));
    }

    protected StagedModelType getStagedModelType() {
        return new StagedModelType(PortalUtil.getClassNameId(BlogsEntry.class.getName()));
    }

    @Override
    protected void performAction(Object object) throws PortalException, SystemException {
        BlogsEntry stagedModel = (BlogsEntry)object;
        StagedModelDataHandlerUtil.exportStagedModel(this._portletDataContext, stagedModel);
    }
}

