/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.alloy;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.Router;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Portlet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlloyPortlet
extends GenericPortlet {
    private static Log _log = LogFactoryUtil.getLog(AlloyPortlet.class);
    private Map<String, String> _defaultRouteParameters = new HashMap<String, String>();

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)portletConfig;
        Portlet portlet = liferayPortletConfig.getPortlet();
        FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
        Router router = friendlyURLMapper.getRouter();
        router.urlToParameters("GET", this._defaultRouteParameters);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        String path = this.getPath((PortletRequest)actionRequest);
        this.include(path, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        String path = this.getPath((PortletRequest)renderRequest);
        this.include(path, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        String path = this.getPath((PortletRequest)resourceRequest);
        this.include(path, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    protected Map<String, String> getDefaultRouteParameters() {
        return this._defaultRouteParameters;
    }

    protected String getPath(PortletRequest portletRequest) {
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)portletRequest.getAttribute("javax.portlet.config");
        Portlet portlet = liferayPortletConfig.getPortlet();
        String controllerPath = ParamUtil.getString((PortletRequest)portletRequest, (String)"controller");
        if (Validator.isNull((String)controllerPath)) {
            Map<String, String> defaultRouteParameters = this.getDefaultRouteParameters();
            controllerPath = defaultRouteParameters.get("controller");
        }
        StringBundler sb = new StringBundler(5);
        sb.append("/WEB-INF/jsp/");
        sb.append(portlet.getFriendlyURLMapping());
        sb.append("/controllers/");
        sb.append(controllerPath);
        sb.append("_controller.jsp");
        return sb.toString();
    }

    protected void include(String path, PortletRequest portletRequest, PortletResponse portletResponse) throws IOException, PortletException {
        PortletRequestDispatcher portletRequestDispatcher = this.getPortletContext().getRequestDispatcher(path);
        if (portletRequestDispatcher == null) {
            _log.error((Object)(String.valueOf(path) + " is not a valid include"));
        } else {
            portletRequestDispatcher.include(portletRequest, portletResponse);
        }
    }
}

