/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.alloy;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.AttachedModel;
import com.liferay.portal.model.AuditedModel;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.GroupedModel;
import com.liferay.portal.model.PersistedModel;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.User;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.bridges.alloy.AlloyController;
import com.liferay.util.bridges.alloy.AlloyPortlet;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseAlloyControllerImpl
implements AlloyController {
    protected static final String CALLED_PROCESS_ACTION = "CALLED_PROCESS_ACTION";
    protected static final String VIEW_PATH = "VIEW_PATH";
    protected static Log log = LogFactoryUtil.getLog(BaseAlloyControllerImpl.class);
    protected String actionPath;
    protected ActionRequest actionRequest;
    protected ActionResponse actionResponse;
    protected AlloyPortlet alloyPortlet;
    protected ClassLoader classLoader;
    protected Class<?> clazz;
    protected Company company;
    protected String controllerPath;
    protected EventRequest eventRequest;
    protected EventResponse eventResponse;
    protected Indexer indexer;
    protected String lifecycle;
    protected LiferayPortletConfig liferayPortletConfig;
    protected LiferayPortletResponse liferayPortletResponse;
    protected Locale locale;
    protected Map<String, Method> methodsMap;
    protected MimeResponse mimeResponse;
    protected PageContext pageContext;
    protected Portlet portlet;
    protected PortletContext portletContext;
    protected PortletRequest portletRequest;
    protected PortletResponse portletResponse;
    protected String redirect;
    protected RenderRequest renderRequest;
    protected RenderResponse renderResponse;
    protected HttpServletRequest request;
    protected ResourceRequest resourceRequest;
    protected ResourceResponse resourceResponse;
    protected HttpServletResponse response;
    protected ServletConfig servletConfig;
    protected ServletContext servletContext;
    protected ThemeDisplay themeDisplay;
    protected String viewPath;
    protected User user;
    private static final String _VIEW_PATH_ERROR = "VIEW_PATH_ERROR";

    @Override
    public void afterPropertiesSet() {
        this.initClass();
        this.initServletVariables();
        this.initPortletVariables();
        this.initThemeDisplayVariables();
        this.initMethods();
        this.initPaths();
        this.initIndexer();
    }

    @Override
    public void execute() throws Exception {
        Method method = this.getMethod(this.actionPath, new Class[0]);
        if (method == null && log.isDebugEnabled()) {
            log.debug((Object)("No method found for action " + this.actionPath));
        }
        if (this.lifecycle.equals("ACTION_PHASE")) {
            this.executeAction(method);
        } else if (this.lifecycle.equals("RENDER_PHASE")) {
            this.executeRender(method);
        } else if (this.lifecycle.equals("RESOURCE_PHASE")) {
            this.executeResource(method);
        }
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    protected void addSuccessMessage() {
        String successMessage = ParamUtil.getString((PortletRequest)this.portletRequest, (String)"successMessage");
        SessionMessages.add((PortletRequest)this.portletRequest, (String)"request_processed", (Object)successMessage);
    }

    protected String buildIncludePath(String viewPath) {
        if (viewPath.equals(_VIEW_PATH_ERROR)) {
            return "/WEB-INF/jsp/".concat(this.portlet.getFriendlyURLMapping()).concat("/views/error.jsp");
        }
        StringBundler sb = new StringBundler(7);
        sb.append("/WEB-INF/jsp/");
        sb.append(this.portlet.getFriendlyURLMapping());
        sb.append("/views/");
        sb.append(this.controllerPath);
        sb.append("/");
        sb.append(viewPath);
        sb.append(".jsp");
        return sb.toString();
    }

    protected Indexer buildIndexer() {
        return null;
    }

    protected void executeAction(Method method) throws Exception {
        if (method != null) {
            method.invoke((Object)this, new Object[0]);
        }
        this.actionRequest.setAttribute(CALLED_PROCESS_ACTION, (Object)Boolean.TRUE.toString());
        if (Validator.isNotNull((String)this.viewPath)) {
            this.actionRequest.setAttribute(VIEW_PATH, (Object)this.viewPath);
            PortalUtil.copyRequestParameters((ActionRequest)this.actionRequest, (ActionResponse)this.actionResponse);
        } else if (Validator.isNotNull((String)this.redirect)) {
            this.actionResponse.sendRedirect(this.redirect);
        }
    }

    protected void executeRender(Method method) throws Exception {
        String includePath;
        PortletRequestDispatcher portletRequestDispatcher;
        boolean calledProcessAction = GetterUtil.getBoolean((String)((String)this.request.getAttribute(CALLED_PROCESS_ACTION)));
        if (!calledProcessAction && method != null) {
            method.invoke((Object)this, new Object[0]);
        }
        if (Validator.isNull((String)this.viewPath)) {
            this.viewPath = this.actionPath;
        }
        if ((portletRequestDispatcher = this.portletContext.getRequestDispatcher(includePath = this.buildIncludePath(this.viewPath))) == null) {
            log.error((Object)(String.valueOf(includePath) + " is not a valid include"));
        } else {
            portletRequestDispatcher.include(this.portletRequest, this.portletResponse);
        }
    }

    protected void executeResource(Method method) throws Exception {
        if (method != null) {
            method.invoke((Object)this, new Object[0]);
        }
    }

    protected Method getMethod(String methodName, Class<?> ... parameterTypes) {
        String methodKey = this.getMethodKey(methodName, parameterTypes);
        return this.methodsMap.get(methodKey);
    }

    protected String getMethodKey(String methodName, Class<?> ... parameterTypes) {
        StringBundler sb = new StringBundler(parameterTypes.length * 2 + 2);
        sb.append(methodName);
        sb.append("#");
        Class<?>[] classArray = parameterTypes;
        int n = parameterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> parameterType = classArray[n2];
            sb.append(parameterType.getName());
            sb.append("#");
            ++n2;
        }
        return sb.toString();
    }

    protected long increment() throws Exception {
        return CounterLocalServiceUtil.increment();
    }

    protected long increment(String name) throws Exception {
        return CounterLocalServiceUtil.increment((String)name);
    }

    protected void initClass() {
        this.clazz = this.getClass();
        this.classLoader = this.clazz.getClassLoader();
    }

    protected void initIndexer() {
        this.indexer = this.buildIndexer();
        if (this.indexer != null) {
            IndexerRegistryUtil.register((Indexer)this.indexer);
        }
    }

    protected void initMethods() {
        Method[] methods;
        this.methodsMap = new HashMap<String, Method>();
        Method[] methodArray = methods = this.clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String methodKey = this.getMethodKey(method.getName(), method.getParameterTypes());
            this.methodsMap.put(methodKey, method);
            ++n2;
        }
    }

    protected void initPaths() {
        Map<String, String> defaultRouteParameters;
        this.controllerPath = ParamUtil.getString((HttpServletRequest)this.request, (String)"controller");
        if (Validator.isNull((String)this.controllerPath)) {
            defaultRouteParameters = this.alloyPortlet.getDefaultRouteParameters();
            this.controllerPath = defaultRouteParameters.get("controller");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Controller path " + this.controllerPath));
        }
        this.actionPath = ParamUtil.getString((HttpServletRequest)this.request, (String)"action");
        if (Validator.isNull((String)this.actionPath)) {
            defaultRouteParameters = this.alloyPortlet.getDefaultRouteParameters();
            this.actionPath = defaultRouteParameters.get("action");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Action path " + this.actionPath));
        }
        this.viewPath = GetterUtil.getString((String)((String)this.request.getAttribute(VIEW_PATH)));
        this.request.removeAttribute(VIEW_PATH);
        if (log.isDebugEnabled()) {
            log.debug((Object)("View path " + this.viewPath));
        }
    }

    protected void initPortletVariables() {
        this.liferayPortletConfig = (LiferayPortletConfig)this.request.getAttribute("javax.portlet.config");
        this.portletContext = this.liferayPortletConfig.getPortletContext();
        this.portlet = this.liferayPortletConfig.getPortlet();
        this.alloyPortlet = (AlloyPortlet)((Object)this.request.getAttribute("javax.portlet.portlet"));
        this.portletRequest = (PortletRequest)this.request.getAttribute("javax.portlet.request");
        this.portletResponse = (PortletResponse)this.request.getAttribute("javax.portlet.response");
        this.liferayPortletResponse = (LiferayPortletResponse)this.portletResponse;
        this.lifecycle = GetterUtil.getString((String)((String)this.request.getAttribute("javax.portlet.lifecycle_phase")));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lifecycle " + this.lifecycle));
        }
        if (this.lifecycle.equals("ACTION_PHASE")) {
            this.actionRequest = (ActionRequest)this.portletRequest;
            this.actionResponse = (ActionResponse)this.portletResponse;
        } else if (this.lifecycle.equals("EVENT_PHASE")) {
            this.eventRequest = (EventRequest)this.portletRequest;
            this.eventResponse = (EventResponse)this.portletResponse;
        } else if (this.lifecycle.equals("RENDER_PHASE")) {
            this.mimeResponse = (MimeResponse)this.portletResponse;
            this.renderRequest = (RenderRequest)this.portletRequest;
            this.renderResponse = (RenderResponse)this.portletResponse;
        } else if (this.lifecycle.equals("RESOURCE_PHASE")) {
            this.mimeResponse = (MimeResponse)this.portletResponse;
            this.resourceRequest = (ResourceRequest)this.portletRequest;
            this.resourceResponse = (ResourceResponse)this.portletResponse;
        }
    }

    protected void initServletVariables() {
        this.servletConfig = this.pageContext.getServletConfig();
        this.servletContext = this.pageContext.getServletContext();
        this.request = (HttpServletRequest)this.pageContext.getRequest();
        this.response = (HttpServletResponse)this.pageContext.getResponse();
    }

    protected void initThemeDisplayVariables() {
        this.themeDisplay = (ThemeDisplay)this.request.getAttribute("THEME_DISPLAY");
        this.company = this.themeDisplay.getCompany();
        this.locale = this.themeDisplay.getLocale();
        this.user = this.themeDisplay.getUser();
    }

    protected void redirectTo(PortletURL portletURL) {
        this.redirectTo(portletURL.toString());
    }

    protected void redirectTo(String redirect) {
        if (!this.lifecycle.equals("ACTION_PHASE")) {
            throw new IllegalArgumentException("redirectTo can only be called during the action phase");
        }
        if (Validator.isNotNull((String)this.viewPath)) {
            throw new IllegalArgumentException("redirectTo cannot be called if render has been called");
        }
        this.redirect = redirect;
    }

    protected void render(String actionPath) {
        if (Validator.isNotNull((String)this.redirect)) {
            throw new IllegalArgumentException("render cannot be called if redirectTo has been called");
        }
        this.viewPath = actionPath;
    }

    protected void renderError(String pattern, Object ... arguments) {
        this.portletRequest.setAttribute("arguments", (Object)arguments);
        this.portletRequest.setAttribute("pattern", (Object)pattern);
        this.render(_VIEW_PATH_ERROR);
    }

    protected String translate(String pattern, Object ... arguments) {
        return LanguageUtil.format((Locale)this.locale, (String)pattern, (Object[])arguments);
    }

    protected void updateAttachedModel(BaseModel<?> baseModel) throws Exception {
        long classPK;
        if (!(baseModel instanceof AttachedModel)) {
            return;
        }
        AttachedModel attachedModel = (AttachedModel)baseModel;
        long classNameId = 0L;
        String className = ParamUtil.getString((HttpServletRequest)this.request, (String)"className");
        if (Validator.isNotNull((String)className)) {
            classNameId = PortalUtil.getClassNameId((String)className);
        }
        if (classNameId > 0L) {
            attachedModel.setClassNameId(classNameId);
        }
        if ((classPK = ParamUtil.getLong((HttpServletRequest)this.request, (String)"classPK")) > 0L) {
            attachedModel.setClassPK(classPK);
        }
    }

    protected void updateAuditedModel(BaseModel<?> baseModel) throws Exception {
        if (!(baseModel instanceof AuditedModel)) {
            return;
        }
        AuditedModel auditedModel = (AuditedModel)baseModel;
        if (baseModel.isNew()) {
            auditedModel.setCompanyId(this.company.getCompanyId());
            auditedModel.setUserId(this.user.getUserId());
            auditedModel.setUserName(this.user.getFullName());
            auditedModel.setCreateDate(new Date());
            auditedModel.setModifiedDate(auditedModel.getCreateDate());
        } else {
            auditedModel.setModifiedDate(new Date());
        }
    }

    protected void updateGroupedModel(BaseModel<?> baseModel) throws Exception {
        if (!(baseModel instanceof GroupedModel) || !baseModel.isNew()) {
            return;
        }
        GroupedModel groupedModel = (GroupedModel)baseModel;
        groupedModel.setGroupId(this.themeDisplay.getScopeGroupId());
    }

    protected void updateModel(BaseModel<?> baseModel) throws Exception {
        BeanPropertiesUtil.setProperties(baseModel, (HttpServletRequest)this.request);
        if (baseModel.isNew()) {
            baseModel.setPrimaryKeyObj((Serializable)Long.valueOf(this.increment()));
        }
        this.updateAuditedModel(baseModel);
        this.updateGroupedModel(baseModel);
        this.updateAttachedModel(baseModel);
        if (baseModel instanceof PersistedModel) {
            PersistedModel persistedModel = (PersistedModel)baseModel;
            persistedModel.persist();
        }
        if (this.indexer != null) {
            this.indexer.reindex(baseModel);
        }
    }

    protected void writeJSON(Object json) throws Exception {
        if (this.actionResponse != null) {
            HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)this.actionResponse);
            response.setContentType("text/javascript");
            ServletResponseUtil.write((HttpServletResponse)response, (String)json.toString());
        } else if (this.mimeResponse != null) {
            this.mimeResponse.setContentType("text/javascript");
            PortletResponseUtil.write((MimeResponse)this.mimeResponse, (String)json.toString());
        }
    }
}

