/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.mvc;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.util.bridges.mvc.ActionCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionCommandCache {
    public static final String ACTION_PACKAGE_NAME = "action.package.prefix";
    public static final ActionCommand EMPTY = new ActionCommand(){

        public boolean processCommand(PortletRequest portletRequest, PortletResponse portletResponse) {
            return false;
        }
    };
    private static final String _ACTION_COMMAND_POSTFIX = "ActionCommand";
    private static Log _log = LogFactoryUtil.getLog(ActionCommandCache.class);
    private Map<String, ActionCommand> _actionCommandCache = new ConcurrentHashMap<String, ActionCommand>();
    private Map<String, List<ActionCommand>> _actionCommandChainCache = new ConcurrentHashMap<String, List<ActionCommand>>();
    private String _packagePrefix;

    public ActionCommandCache(String packagePrefix) {
        if (!packagePrefix.endsWith(".")) {
            packagePrefix = String.valueOf(packagePrefix) + ".";
        }
        this._packagePrefix = packagePrefix;
    }

    public ActionCommand getActionCommand(String actionCommandName) {
        String className = null;
        try {
            ActionCommand actionCommand = this._actionCommandCache.get(actionCommandName);
            if (actionCommand != null) {
                return actionCommand;
            }
            StringBundler sb = new StringBundler(4);
            sb.append(this._packagePrefix);
            sb.append(Character.toUpperCase(actionCommandName.charAt(0)));
            sb.append(actionCommandName.substring(1, actionCommandName.length()));
            sb.append(_ACTION_COMMAND_POSTFIX);
            className = sb.toString();
            actionCommand = (ActionCommand)InstanceFactory.newInstance((String)className);
            this._actionCommandCache.put(actionCommandName, actionCommand);
            return actionCommand;
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to instantiate ActionCommand " + className));
            }
            this._actionCommandCache.put(actionCommandName, EMPTY);
            return EMPTY;
        }
    }

    public List<ActionCommand> getActionCommandChain(String actionCommandChain) {
        String[] actionCommandNames;
        List<ActionCommand> actionCommands = this._actionCommandChainCache.get(actionCommandChain);
        if (actionCommands != null) {
            return actionCommands;
        }
        actionCommands = new ArrayList<ActionCommand>();
        String[] stringArray = actionCommandNames = StringUtil.split((String)actionCommandChain);
        int n = actionCommandNames.length;
        int n2 = 0;
        while (n2 < n) {
            String actionCommandName = stringArray[n2];
            ActionCommand actionCommand = this.getActionCommand(actionCommandName);
            if (actionCommand != EMPTY) {
                actionCommands.add(actionCommand);
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to find ActionCommand " + actionCommandChain));
            }
            ++n2;
        }
        this._actionCommandChainCache.put(actionCommandChain, actionCommands);
        return actionCommands;
    }

    public boolean isEmpty() {
        return this._actionCommandCache.isEmpty();
    }
}

