/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.mvc;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortlet;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalClassInvoker;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.bridges.mvc.ActionCommand;
import com.liferay.util.bridges.mvc.ActionCommandCache;
import java.io.IOException;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;

public class MVCPortlet
extends LiferayPortlet {
    protected String aboutTemplate;
    protected boolean clearRequestParameters;
    protected String configTemplate;
    protected boolean copyRequestParameters;
    protected String editDefaultsTemplate;
    protected String editGuestTemplate;
    protected String editTemplate;
    protected String helpTemplate;
    protected String templatePath;
    protected String previewTemplate;
    protected String printTemplate;
    protected String viewTemplate;
    private static Log _log = LogFactoryUtil.getLog(MVCPortlet.class);
    private ActionCommandCache _actionCommandCache;

    public void doAbout(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.aboutTemplate, renderRequest, renderResponse);
    }

    public void doConfig(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.configTemplate, renderRequest, renderResponse);
    }

    public void doEdit(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        PortletPreferences portletPreferences = renderRequest.getPreferences();
        if (portletPreferences == null) {
            super.doEdit(renderRequest, renderResponse);
        } else {
            this.include(this.editTemplate, renderRequest, renderResponse);
        }
    }

    public void doEditDefaults(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        PortletPreferences portletPreferences = renderRequest.getPreferences();
        if (portletPreferences == null) {
            super.doEdit(renderRequest, renderResponse);
        } else {
            this.include(this.editDefaultsTemplate, renderRequest, renderResponse);
        }
    }

    public void doEditGuest(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        PortletPreferences portletPreferences = renderRequest.getPreferences();
        if (portletPreferences == null) {
            super.doEdit(renderRequest, renderResponse);
        } else {
            this.include(this.editGuestTemplate, renderRequest, renderResponse);
        }
    }

    public void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.helpTemplate, renderRequest, renderResponse);
    }

    public void doPreview(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.previewTemplate, renderRequest, renderResponse);
    }

    public void doPrint(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.printTemplate, renderRequest, renderResponse);
    }

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.viewTemplate, renderRequest, renderResponse);
    }

    public void init() throws PortletException {
        super.init();
        this.templatePath = this._getInitParameter("template-path");
        if (Validator.isNull((String)this.templatePath)) {
            this.templatePath = "/";
        } else {
            if (this.templatePath.contains("\\") || this.templatePath.contains("//") || this.templatePath.contains(".") || this.templatePath.contains(" ")) {
                throw new PortletException("template-path " + this.templatePath + " has invalid characters");
            }
            if (!this.templatePath.startsWith("/") || !this.templatePath.endsWith("/")) {
                throw new PortletException("template-path " + this.templatePath + " must start and end with a /");
            }
        }
        this.aboutTemplate = this._getInitParameter("about-template");
        this.configTemplate = this._getInitParameter("config-template");
        this.editTemplate = this._getInitParameter("edit-template");
        this.editDefaultsTemplate = this._getInitParameter("edit-defaults-template");
        this.editGuestTemplate = this._getInitParameter("edit-guest-template");
        this.helpTemplate = this._getInitParameter("help-template");
        this.previewTemplate = this._getInitParameter("preview-template");
        this.printTemplate = this._getInitParameter("print-template");
        this.viewTemplate = this._getInitParameter("view-template");
        this.clearRequestParameters = GetterUtil.getBoolean((String)this.getInitParameter("clear-request-parameters"));
        this.copyRequestParameters = GetterUtil.getBoolean((String)this.getInitParameter("copy-request-parameters"));
        String packagePrefix = this.getInitParameter("action.package.prefix");
        if (Validator.isNotNull((String)packagePrefix)) {
            this._actionCommandCache = new ActionCommandCache(packagePrefix);
        }
    }

    public void invokeTaglibDiscussion(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        PortletConfig portletConfig = this.getPortletConfig();
        PortalClassInvoker.invoke((boolean)true, (String)"com.liferay.portlet.messageboards.action.EditDiscussionAction", (String)"processAction", (String[])new String[]{"org.apache.struts.action.ActionMapping", "org.apache.struts.action.ActionForm", PortletConfig.class.getName(), ActionRequest.class.getName(), ActionResponse.class.getName()}, (Object[])new Object[]{null, null, portletConfig, actionRequest, actionResponse});
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        super.processAction(actionRequest, actionResponse);
        if (this.copyRequestParameters) {
            PortalUtil.copyRequestParameters((ActionRequest)actionRequest, (ActionResponse)actionResponse);
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        String path = this.getPath((PortletRequest)resourceRequest);
        if (path != null) {
            this.include(path, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse, "RESOURCE_PHASE");
        } else {
            super.serveResource(resourceRequest, resourceResponse);
        }
    }

    protected boolean callActionMethod(ActionRequest request, ActionResponse response) throws PortletException {
        if (this._actionCommandCache == null) {
            return super.callActionMethod(request, response);
        }
        String actionName = ParamUtil.getString((PortletRequest)request, (String)"javax.portlet.action");
        if (!actionName.contains(",")) {
            ActionCommand actionCommand = this._actionCommandCache.getActionCommand(actionName);
            if (actionCommand != ActionCommandCache.EMPTY) {
                return actionCommand.processCommand((PortletRequest)request, (PortletResponse)response);
            }
        } else {
            List<ActionCommand> actionCommands = this._actionCommandCache.getActionCommandChain(actionName);
            if (actionCommands.isEmpty()) {
                return false;
            }
            for (ActionCommand actionCommand : actionCommands) {
                if (actionCommand.processCommand((PortletRequest)request, (PortletResponse)response)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void checkPath(String path) throws PortletException {
        if (!path.startsWith(this.templatePath) || path.contains("..") || !PortalUtil.isValidResourceId((String)path)) {
            throw new PortletException("Path " + path + " is not accessible by this portlet");
        }
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        String path = this.getPath((PortletRequest)renderRequest);
        if (path != null) {
            if (!this.isProcessRenderRequest(renderRequest)) {
                renderRequest.setAttribute("PORTLET_DECORATE", (Object)Boolean.FALSE);
                return;
            }
            WindowState windowState = renderRequest.getWindowState();
            if (windowState.equals((Object)WindowState.MINIMIZED)) {
                return;
            }
            this.include(path, renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected String getPath(PortletRequest portletRequest) {
        String mvcPath = portletRequest.getParameter("mvcPath");
        if (mvcPath == null) {
            mvcPath = portletRequest.getParameter("jspPage");
        }
        return mvcPath;
    }

    protected void include(String path, ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        this.include(path, (PortletRequest)actionRequest, (PortletResponse)actionResponse, "ACTION_PHASE");
    }

    protected void include(String path, EventRequest eventRequest, EventResponse eventResponse) throws IOException, PortletException {
        this.include(path, (PortletRequest)eventRequest, (PortletResponse)eventResponse, "EVENT_PHASE");
    }

    protected void include(String path, PortletRequest portletRequest, PortletResponse portletResponse, String lifecycle) throws IOException, PortletException {
        PortletContext portletContext = this.getPortletContext();
        PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher(path);
        if (portletRequestDispatcher == null) {
            _log.error((Object)(String.valueOf(path) + " is not a valid include"));
        } else {
            this.checkPath(path);
            portletRequestDispatcher.include(portletRequest, portletResponse);
        }
        if (this.clearRequestParameters && lifecycle.equals("RENDER_PHASE")) {
            portletResponse.setProperty("clear-request-parameters", Boolean.TRUE.toString());
        }
    }

    protected void include(String path, RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(path, (PortletRequest)renderRequest, (PortletResponse)renderResponse, "RENDER_PHASE");
    }

    protected void include(String path, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        this.include(path, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse, "RESOURCE_PHASE");
    }

    private String _getInitParameter(String name) {
        String value = this.getInitParameter(name);
        if (value != null) {
            return value;
        }
        if (name.equals("template-path")) {
            return this.getInitParameter("jsp-path");
        }
        if (name.endsWith("-template")) {
            name = String.valueOf(name.substring(0, name.length() - 9)) + "-jsp";
            return this.getInitParameter(name);
        }
        return null;
    }
}

