/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.jazzy;

import com.liferay.util.jazzy.InvalidWord;
import com.swabunga.spell.engine.Word;
import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSpellCheckListener
implements SpellCheckListener {
    private String _text;
    private char[] _textCharArray;
    private List<InvalidWord> _invalidWords;

    public BasicSpellCheckListener(String text) {
        this._text = text;
        this._textCharArray = text.toCharArray();
        this._invalidWords = new ArrayList<InvalidWord>();
    }

    public void spellingError(SpellCheckEvent event) {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (Word word : event.getSuggestions()) {
            suggestions.add(word.getWord());
        }
        int pos = event.getWordContextPosition();
        if (pos >= 0 && (pos == 0 || pos > 0 && !this._isInsideHtmlTag(pos) && this._text.charAt(pos - 1) != '&' && event.getInvalidWord().length() > 1)) {
            this._invalidWords.add(new InvalidWord(event.getInvalidWord(), suggestions, event.getWordContext(), pos));
        }
    }

    public List<InvalidWord> getInvalidWords() {
        return this._invalidWords;
    }

    private boolean _isInsideHtmlTag(int pos) {
        boolean insideHtmlTag = false;
        int i = pos;
        while (i >= 0) {
            if (this._textCharArray[i] == '<') {
                insideHtmlTag = true;
                break;
            }
            if (this._textCharArray[i] == '>') break;
            --i;
        }
        if (insideHtmlTag) {
            i = pos;
            while (i < this._textCharArray.length) {
                if (this._textCharArray[i] == '<') {
                    insideHtmlTag = false;
                    break;
                }
                if (this._textCharArray[i] == '>') break;
                ++i;
            }
        }
        return insideHtmlTag;
    }
}

