/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieUtil {
    public static String get(HttpServletRequest request, String name) {
        return CookieUtil.get(request, name, true);
    }

    public static String get(HttpServletRequest request, String name, boolean toUpperCase) {
        Cookie cookie;
        Map<String, Cookie> cookieMap = CookieUtil._getCookieMap(request);
        if (toUpperCase) {
            name = name.toUpperCase();
        }
        if ((cookie = cookieMap.get(name)) == null) {
            return null;
        }
        return cookie.getValue();
    }

    private static Map<String, Cookie> _getCookieMap(HttpServletRequest request) {
        Map<String, Cookie> cookieMap = (Map<String, Cookie>)request.getAttribute(CookieUtil.class.getName());
        if (cookieMap != null) {
            return cookieMap;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            cookieMap = Collections.emptyMap();
        } else {
            cookieMap = new HashMap<String, Cookie>(cookies.length * 4 / 3);
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                String cookieName = GetterUtil.getString((String)cookie.getName());
                cookieName = cookieName.toUpperCase();
                cookieMap.put(cookieName, cookie);
                ++n2;
            }
        }
        request.setAttribute(CookieUtil.class.getName(), cookieMap);
        return cookieMap;
    }
}

