/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.freemarker;

import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.memory.FinalizeAction;
import com.liferay.portal.kernel.memory.FinalizeManager;
import freemarker.ext.jsp.TaglibFactory;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

public class FreeMarkerTaglibFactoryUtil
implements CacheRegistryItem {
    private static volatile FreeMarkerTaglibFactoryUtil _instance;
    private final String _contextPath;
    private final String _registryName;
    private Map<String, TemplateModel> _templateModels = new ConcurrentHashMap<String, TemplateModel>();

    public static TemplateHashModel createTaglibFactory(ServletContext servletContext) {
        return new TaglibFactoryCacheWrapper(servletContext);
    }

    public String getRegistryName() {
        return this._registryName;
    }

    public void invalidate() {
        this._templateModels.clear();
    }

    private FreeMarkerTaglibFactoryUtil(String contextPath) {
        this._contextPath = contextPath;
        this._registryName = FreeMarkerTaglibFactoryUtil.class.getName().concat("@").concat(this._contextPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static FreeMarkerTaglibFactoryUtil getInstance(ServletContext servletContext) {
        if (_instance != null) return _instance;
        Class<FreeMarkerTaglibFactoryUtil> clazz = FreeMarkerTaglibFactoryUtil.class;
        synchronized (FreeMarkerTaglibFactoryUtil.class) {
            if (_instance != null) return _instance;
            String contextPath = servletContext.getContextPath();
            _instance = new FreeMarkerTaglibFactoryUtil(contextPath);
            CacheRegistryUtil.unregister((String)FreeMarkerTaglibFactoryUtil._instance._registryName);
            CacheRegistryUtil.register((CacheRegistryItem)_instance);
            final String name = FreeMarkerTaglibFactoryUtil._instance._registryName;
            FinalizeManager.register((Object)servletContext, (FinalizeAction)new FinalizeAction(){

                public void doFinalize() {
                    CacheRegistryUtil.unregister((String)name);
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _instance;
        }
    }

    private static class TaglibFactoryCacheWrapper
    implements TemplateHashModel {
        private TaglibFactory _taglibFactory;
        private Map<String, TemplateModel> _templateModels;

        public TaglibFactoryCacheWrapper(ServletContext servletContext) {
            FreeMarkerTaglibFactoryUtil freeMarkerTaglibFactoryUtil = FreeMarkerTaglibFactoryUtil.getInstance(servletContext);
            this._templateModels = freeMarkerTaglibFactoryUtil._templateModels;
            this._taglibFactory = new TaglibFactory(servletContext);
        }

        public TemplateModel get(String uri) throws TemplateModelException {
            TemplateModel templateModel = this._templateModels.get(uri);
            if (templateModel == null) {
                templateModel = this._taglibFactory.get(uri);
                this._templateModels.put(uri, templateModel);
            }
            return templateModel;
        }

        public boolean isEmpty() {
            return false;
        }
    }
}

