/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.OptionArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import com.lowagie.toolbox.swing.PdfInformationPanel;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class CompressDecompressPageContent
extends AbstractTool {
    public CompressDecompressPageContent() {
        FileArgument f = new FileArgument(this, "srcfile", "The file you want to compress/decompress", false, new PdfFilter());
        f.setLabel(new PdfInformationPanel());
        this.arguments.add(f);
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the compressed/decompressed PDF has to be written", true, new PdfFilter()));
        OptionArgument oa = new OptionArgument(this, "compress", "compress");
        oa.addOption("Compress page content", "true");
        oa.addOption("Decompress page content", "false");
        this.arguments.add(oa);
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Compress/Decompress", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Compress/Decompress OPENED ===");
    }

    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        CompressDecompressPageContent tool = new CompressDecompressPageContent();
        if (args.length < 2) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            boolean compress = "true".equals(this.getValue("compress"));
            PdfReader reader = new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath());
            PdfStamper stamper = new PdfStamper(reader, new FileOutputStream(this.getDestPathPDF()));
            ArrayList arrayList = this.arguments;
            synchronized (arrayList) {
                Document.compress = compress;
                int total = reader.getNumberOfPages() + 1;
                for (int i = 1; i < total; ++i) {
                    reader.setPageContent(i, reader.getPageContent(i));
                }
                stamper.close();
                Document.compress = true;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    static {
        CompressDecompressPageContent.addVersion("$Id: CompressDecompressPageContent.java 3271 2008-04-18 20:39:42Z xlv $");
    }
}

