/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxb.model;

import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxb.model.JAXBClass;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Type;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBMember
implements Comparable<JAXBMember> {
    protected AnnotationDesc xmlAnnotation;
    protected ProgramElementDoc property;
    protected String name;
    protected JAXBClass klass;
    private boolean isIDREF;
    private boolean isID;
    private static HashMap<String, Object> hmKnownUnknownXSDTypes = new HashMap();

    public JAXBMember(JAXBClass klass, ProgramElementDoc property, String name, AnnotationDesc xmlAnnotation) {
        this.xmlAnnotation = xmlAnnotation;
        this.property = property;
        this.name = name;
        this.klass = klass;
        this.isIDREF = Utils.findAnnotation(property, XmlIDREF.class) != null;
        this.isID = Utils.findAnnotation(property, XmlID.class) != null;
    }

    public String getName() {
        return this.name;
    }

    public Doc getJavaDoc() {
        return this.property;
    }

    private Type getType() {
        if (this.property.isMethod()) {
            return ((MethodDoc)this.property).returnType();
        }
        return ((FieldDoc)this.property).type();
    }

    public boolean isCollection() {
        return Utils.isCollection(this.getType());
    }

    public Type getJavaType() {
        return Utils.getCollectionType(this.getType(), this.klass.getDoclet());
    }

    public String getJavaTypeName() {
        return this.getJavaType().qualifiedTypeName();
    }

    public boolean isJAXBType() {
        Type type = this.getJavaType();
        return !type.isPrimitive() && this.klass.getRegistry().isJAXBClass(type.qualifiedTypeName());
    }

    public String getXSDType() {
        String typeName = this.getJavaTypeName();
        if (typeName.equals("java.lang.String")) {
            return "xsd:string";
        }
        if (typeName.equals("java.lang.Character") || typeName.equals("char")) {
            return "xsd:string";
        }
        if (typeName.equals("java.util.Date")) {
            return "xsd:datetime";
        }
        if (typeName.equals("java.lang.Integer") || typeName.equals("int")) {
            return "xsd:int";
        }
        if (typeName.equals("java.lang.Long") || typeName.equals("long")) {
            return "xsd:long";
        }
        if (typeName.equals("java.lang.Short") || typeName.equals("short")) {
            return "xsd:short";
        }
        if (typeName.equals("java.lang.Byte") || typeName.equals("byte")) {
            return "xsd:byte";
        }
        if (typeName.equals("java.lang.Float") || typeName.equals("float")) {
            return "xsd:float";
        }
        if (typeName.equals("java.lang.Double") || typeName.equals("double")) {
            return "xsd:double";
        }
        if (typeName.equals("java.lang.Boolean") || typeName.equals("boolean")) {
            return "xsd:boolean";
        }
        if (typeName.equals("java.lang.Object")) {
            return "xsd:any";
        }
        ClassDoc type = this.getJavaType().asClassDoc();
        if (type.isEnum()) {
            FieldDoc[] constants = type.enumConstants();
            StringBuffer ret = new StringBuffer();
            boolean first = true;
            for (FieldDoc constant : constants) {
                if (!first) {
                    ret.append(" | ");
                } else {
                    first = false;
                }
                ret.append(constant.name());
            }
            return ret.toString();
        }
        if (null == hmKnownUnknownXSDTypes.get(typeName)) {
            System.err.println("WARNING: unknown XSD type " + typeName);
            hmKnownUnknownXSDTypes.put(typeName, Boolean.TRUE);
        }
        return typeName;
    }

    public boolean isIDREF() {
        return this.isIDREF;
    }

    public boolean isID() {
        return this.isID;
    }

    @Override
    public int compareTo(JAXBMember other) {
        return this.name.compareToIgnoreCase(other.name);
    }

    public String getJSONType() {
        String typeName = this.getJavaTypeName();
        if (typeName.equals("java.lang.String")) {
            return "String";
        }
        if (typeName.equals("java.lang.Character") || typeName.equals("char")) {
            return "String";
        }
        if (typeName.equals("java.util.Date")) {
            return "Date";
        }
        if (typeName.equals("java.lang.Integer") || typeName.equals("int")) {
            return "Number";
        }
        if (typeName.equals("java.lang.Long") || typeName.equals("long")) {
            return "Number";
        }
        if (typeName.equals("java.lang.Short") || typeName.equals("short")) {
            return "Number";
        }
        if (typeName.equals("java.lang.Byte") || typeName.equals("byte")) {
            return "Number";
        }
        if (typeName.equals("java.lang.Float") || typeName.equals("float")) {
            return "Number";
        }
        if (typeName.equals("java.lang.Double") || typeName.equals("double")) {
            return "Number";
        }
        if (typeName.equals("java.lang.Boolean") || typeName.equals("boolean")) {
            return "Boolean";
        }
        if (typeName.equals("java.lang.Object")) {
            return "Object";
        }
        ClassDoc type = this.getJavaType().asClassDoc();
        if (type.isEnum()) {
            FieldDoc[] constants = type.enumConstants();
            StringBuffer ret = new StringBuffer();
            boolean first = true;
            for (FieldDoc constant : constants) {
                if (!first) {
                    ret.append(" | ");
                } else {
                    first = false;
                }
                ret.append("'").append(constant.name()).append("'");
            }
            return ret.toString();
        }
        if (null == hmKnownUnknownXSDTypes.get(typeName)) {
            System.err.println("WARNING: unknown XSD type " + typeName);
            hmKnownUnknownXSDTypes.put(typeName, Boolean.TRUE);
        }
        return typeName;
    }
}

