/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.direct;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.cql.CqlOperationResultImpl;
import com.netflix.astyanax.cql.CqlPreparedStatement;
import com.netflix.astyanax.cql.CqlStatementResult;
import com.netflix.astyanax.cql.direct.DirectCqlStatementResultImpl;
import com.netflix.astyanax.cql.util.AsyncOperationResult;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class DirectCqlPreparedStatement
implements CqlPreparedStatement {
    private final Session session;
    private final PreparedStatement pStmt;
    private final List<Object> bindValues = new ArrayList<Object>();

    public DirectCqlPreparedStatement(Session session, PreparedStatement pStmt) {
        this.session = session;
        this.pStmt = pStmt;
    }

    public OperationResult<CqlStatementResult> execute() throws ConnectionException {
        BoundStatement bStmt = this.pStmt.bind(this.bindValues.toArray());
        ResultSet resultSet = this.session.execute((Statement)bStmt);
        DirectCqlStatementResultImpl result = new DirectCqlStatementResultImpl(resultSet);
        return new CqlOperationResultImpl<CqlStatementResult>(resultSet, result);
    }

    public ListenableFuture<OperationResult<CqlStatementResult>> executeAsync() throws ConnectionException {
        BoundStatement bStmt = this.pStmt.bind(this.bindValues.toArray());
        ResultSetFuture rsFuture = this.session.executeAsync((Statement)bStmt);
        return new AsyncOperationResult<CqlStatementResult>(rsFuture){

            @Override
            public OperationResult<CqlStatementResult> getOperationResult(ResultSet rs) {
                DirectCqlStatementResultImpl result = new DirectCqlStatementResultImpl(rs);
                return new CqlOperationResultImpl<CqlStatementResult>(rs, result);
            }
        };
    }

    public <V> CqlPreparedStatement withByteBufferValue(V value, Serializer<V> serializer) {
        this.bindValues.add(value);
        return this;
    }

    public CqlPreparedStatement withValue(ByteBuffer value) {
        this.bindValues.add(value);
        return this;
    }

    public CqlPreparedStatement withValues(List<ByteBuffer> values) {
        this.bindValues.addAll(values);
        return this;
    }

    public CqlPreparedStatement withStringValue(String value) {
        this.bindValues.add(value);
        return this;
    }

    public CqlPreparedStatement withIntegerValue(Integer value) {
        this.bindValues.add(value);
        return this;
    }

    public CqlPreparedStatement withBooleanValue(Boolean value) {
        this.bindValues.add(value);
        return this;
    }

    public CqlPreparedStatement withDoubleValue(Double value) {
        this.bindValues.add(value);
        return this;
    }

    public CqlPreparedStatement withLongValue(Long value) {
        this.bindValues.add(value);
        return this;
    }

    public CqlPreparedStatement withFloatValue(Float value) {
        this.bindValues.add(value);
        return this;
    }

    public CqlPreparedStatement withShortValue(Short value) {
        this.bindValues.add(value);
        return this;
    }

    public CqlPreparedStatement withUUIDValue(UUID value) {
        this.bindValues.add(value);
        return this;
    }

    public PreparedStatement getInnerPreparedStatement() {
        return this.pStmt;
    }
}

