/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads.model;

import java.util.Collection;

public class CqlRowSlice<K> {
    private Collection<K> keys;
    private RowRange<K> range = new RowRange();

    public CqlRowSlice(Collection<K> keys) {
        this.keys = keys;
    }

    public CqlRowSlice(K startKey, K endKey, String startToken, String endToken, int count) {
        ((RowRange)this.range).startKey = startKey;
        ((RowRange)this.range).endKey = endKey;
        ((RowRange)this.range).startToken = startToken;
        ((RowRange)this.range).endToken = endToken;
        this.range.count = count;
    }

    public Collection<K> getKeys() {
        return this.keys;
    }

    public RowRange<K> getRange() {
        return this.range;
    }

    public boolean isCollectionQuery() {
        return this.keys != null && this.keys.size() > 0;
    }

    public boolean isRangeQuery() {
        return !this.isCollectionQuery() && this.range != null;
    }

    public static class RowRange<K> {
        private K startKey;
        private K endKey;
        private String startToken;
        private String endToken;
        int count;

        public K getStartKey() {
            return this.startKey;
        }

        public K getEndKey() {
            return this.endKey;
        }

        public String getStartToken() {
            return this.startToken;
        }

        public String getEndToken() {
            return this.endToken;
        }

        public int getCount() {
            return this.count;
        }
    }
}

